/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.block;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.block.BlockCPAFactory;
import org.sosy_lab.cpachecker.cpa.block.BlockState;
import org.sosy_lab.cpachecker.cpa.block.BlockTransferRelation;

public class BlockCPABackward
extends AbstractCPA {
    private BlockNode blockNode;

    public BlockCPABackward() {
        super("sep", "sep", new FlatLatticeDomain(), new BlockTransferRelation.BackwardBlockTransferRelation());
    }

    public void init(BlockNode pBlockNode) {
        this.blockNode = pBlockNode;
        TransferRelation relation = this.getTransferRelation();
        Preconditions.checkState((boolean)(relation instanceof BlockTransferRelation.BackwardBlockTransferRelation), (String)"Expected %s but got %s", BlockTransferRelation.BackwardBlockTransferRelation.class, relation.getClass());
        ((BlockTransferRelation.BackwardBlockTransferRelation)relation).init(pBlockNode);
    }

    public static CPAFactory factory() {
        return new BlockCPAFactory(AnalysisDirection.BACKWARD);
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition partition) throws InterruptedException {
        return new BlockState(node, this.blockNode, AnalysisDirection.BACKWARD, BlockState.BlockStateType.INITIAL, false);
    }

    public static BlockCPABackward create() {
        return new BlockCPABackward();
    }
}

