/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.block;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.block.BlockCPA;
import org.sosy_lab.cpachecker.cpa.block.BlockCPABackward;

class BlockCPAFactory
extends AbstractCPAFactory {
    private CFA cfa;
    private final AnalysisDirection analysisDirection;

    public BlockCPAFactory(AnalysisDirection pAnalysisDirection) {
        this.analysisDirection = pAnalysisDirection;
    }

    @Override
    @CanIgnoreReturnValue
    public <T> BlockCPAFactory set(T pObject, Class<T> pClass) {
        if (CFA.class.isAssignableFrom(pClass)) {
            this.cfa = (CFA)pObject;
        } else {
            super.set(pObject, pClass);
        }
        return this;
    }

    @Override
    public ConfigurableProgramAnalysis createInstance() throws InvalidConfigurationException {
        Preconditions.checkNotNull((Object)this.cfa, (Object)"CFA instance needed to create LocationCPA");
        switch (this.analysisDirection) {
            case FORWARD: {
                return BlockCPA.create();
            }
            case BACKWARD: {
                return BlockCPABackward.create();
            }
        }
        throw new AssertionError((Object)("AnalysisDirection " + this.analysisDirection + "does not exist"));
    }
}

