/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.block;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.block.BlockCPA;
import org.sosy_lab.cpachecker.cpa.block.BlockEntryReachedTargetInformation;

public class BlockState
implements AbstractQueryableState,
Partitionable,
Serializable,
Targetable {
    private static final long serialVersionUID = 3805801L;
    private final CFANode targetCFANode;
    private final CFANode node;
    private final AnalysisDirection direction;
    private final BlockStateType type;
    private final boolean wasLoopHeadEncountered;

    public BlockState(CFANode pNode, BlockNode pTargetNode, AnalysisDirection pDirection, BlockStateType pType, boolean pWasLoopHeadEncountered) {
        this.node = pNode;
        this.direction = pDirection;
        this.type = pType;
        this.targetCFANode = pTargetNode == null ? CFANode.newDummyCFANode() : (this.direction == AnalysisDirection.FORWARD ? pTargetNode.getLastNode() : pTargetNode.getStartNode());
        this.wasLoopHeadEncountered = pWasLoopHeadEncountered;
    }

    public boolean hasLoopHeadEncountered() {
        return this.wasLoopHeadEncountered;
    }

    public CFANode getLocationNode() {
        return this.node;
    }

    public BlockStateType getType() {
        return this.type;
    }

    @Override
    public String getCPAName() {
        return BlockCPA.class.getSimpleName();
    }

    @Override
    public @Nullable Object getPartitionKey() {
        return this;
    }

    @Override
    public String toString() {
        return "Location: " + this.node;
    }

    @Override
    public @NonNull Set<Targetable.TargetInformation> getTargetInformation() throws IllegalStateException {
        return this.isTarget() ? ImmutableSet.of((Object)new BlockEntryReachedTargetInformation(this.targetCFANode)) : ImmutableSet.of();
    }

    @Override
    public boolean equals(Object pO) {
        if (!(pO instanceof BlockState)) {
            return false;
        }
        BlockState that = (BlockState)pO;
        return this.direction == that.direction && Objects.equals(this.targetCFANode, that.targetCFANode) && Objects.equals(this.node, that.node) && this.type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.targetCFANode, this.node, this.direction, this.type});
    }

    @Override
    public boolean isTarget() {
        return this.targetCFANode.equals(this.node);
    }

    public static enum BlockStateType {
        INITIAL,
        MID,
        FINAL;

    }
}

