/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.algorithm.distributed_summaries.decomposition.BlockNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.block.BlockState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public abstract class BlockTransferRelation
implements TransferRelation {
    protected ImmutableSet<CFAEdge> edges;
    protected ImmutableSet<CFANode> nodes;
    protected CFANode targetNode;
    protected BlockNode bNode;

    public void init(BlockNode pBlockNode) {
        assert (this.edges == null);
        assert (this.nodes == null);
        assert (this.targetNode == null);
        assert (this.bNode == null);
        assert (pBlockNode != null);
        this.edges = ImmutableSet.copyOf(pBlockNode.getEdgesInBlock());
        this.nodes = ImmutableSet.copyOf(pBlockNode.getNodesInBlock());
        this.targetNode = pBlockNode.getLastNode();
        this.bNode = pBlockNode;
    }

    private boolean isTargetLoopHead(BlockState pBlockState) {
        return pBlockState.getLocationNode().equals(this.targetNode);
    }

    protected boolean shouldComputeSuccessor(BlockState pBlockState) {
        return !this.isTargetLoopHead(pBlockState) || !pBlockState.hasLoopHeadEncountered();
    }

    protected boolean hasLoopHeadEncountered(BlockState pBlockState) {
        if (this.isTargetLoopHead(pBlockState)) {
            return !pBlockState.hasLoopHeadEncountered();
        }
        return pBlockState.hasLoopHeadEncountered();
    }

    public abstract Collection<BlockState> getAbstractSuccessorsForEdge(AbstractState var1, Precision var2, CFAEdge var3);

    public abstract Collection<BlockState> getAbstractSuccessors(AbstractState var1, Precision var2) throws CPATransferException;

    static class BackwardBlockTransferRelation
    extends BlockTransferRelation {
        BackwardBlockTransferRelation() {
        }

        @Override
        public void init(BlockNode pBlockNode) {
            super.init(pBlockNode);
            this.targetNode = pBlockNode.getStartNode();
        }

        private BlockState.BlockStateType getType(CFANode pNode) {
            return pNode.equals(this.bNode.getStartNode()) ? BlockState.BlockStateType.MID : BlockState.BlockStateType.FINAL;
        }

        @Override
        public Collection<BlockState> getAbstractSuccessorsForEdge(AbstractState element, Precision prec, CFAEdge cfaEdge) {
            Preconditions.checkNotNull((Object)this.edges, (Object)"init method must be called before starting the analysis (edges == null)");
            BlockState blockState = (BlockState)element;
            CFANode node = blockState.getLocationNode();
            if (Sets.intersection((Set)ImmutableSet.copyOf(CFAUtils.allEnteringEdges(node)), (Set)this.edges).contains((Object)cfaEdge)) {
                if (!this.shouldComputeSuccessor(blockState)) {
                    return ImmutableSet.of();
                }
                BlockState successor = new BlockState(cfaEdge.getPredecessor(), this.bNode, AnalysisDirection.BACKWARD, this.getType(cfaEdge.getPredecessor()), this.hasLoopHeadEncountered(blockState));
                return ImmutableList.of((Object)successor);
            }
            return ImmutableSet.of();
        }

        @Override
        public Collection<BlockState> getAbstractSuccessors(AbstractState element, Precision prec) throws CPATransferException {
            Preconditions.checkNotNull((Object)this.nodes, (Object)"init method must be called before starting the analysis (nodes == null)");
            BlockState blockState = (BlockState)element;
            if (!this.shouldComputeSuccessor(blockState)) {
                return ImmutableSet.of();
            }
            CFANode node = blockState.getLocationNode();
            FluentIterable<CFANode> predecessors = CFAUtils.predecessorsOf(node);
            return predecessors.filter(n -> this.nodes.contains(n)).transform(n -> new BlockState((CFANode)n, this.bNode, AnalysisDirection.BACKWARD, this.getType((CFANode)n), this.hasLoopHeadEncountered(blockState))).toList();
        }
    }

    static class ForwardBlockTransferRelation
    extends BlockTransferRelation {
        private BlockState.BlockStateType getType(CFANode pNode) {
            return pNode.equals(this.bNode.getLastNode()) ? BlockState.BlockStateType.MID : BlockState.BlockStateType.FINAL;
        }

        @Override
        public Collection<BlockState> getAbstractSuccessorsForEdge(AbstractState element, Precision prec, CFAEdge cfaEdge) {
            Preconditions.checkNotNull((Object)this.edges, (Object)"init method must be called before starting the analysis (edges == null)");
            BlockState blockState = (BlockState)element;
            CFANode node = blockState.getLocationNode();
            if (Sets.intersection((Set)ImmutableSet.copyOf(CFAUtils.allLeavingEdges(node)), (Set)this.edges).contains((Object)cfaEdge)) {
                if (!this.shouldComputeSuccessor(blockState)) {
                    return ImmutableSet.of();
                }
                BlockState successor = new BlockState(cfaEdge.getSuccessor(), this.bNode, AnalysisDirection.FORWARD, this.getType(cfaEdge.getSuccessor()), this.hasLoopHeadEncountered(blockState));
                return ImmutableList.of((Object)successor);
            }
            return ImmutableList.of();
        }

        @Override
        public Collection<BlockState> getAbstractSuccessors(AbstractState element, Precision prec) throws CPATransferException {
            Preconditions.checkNotNull((Object)this.nodes, (Object)"init method must be called before starting the analysis (nodes == null)");
            BlockState blockState = (BlockState)element;
            if (!this.shouldComputeSuccessor(blockState)) {
                return ImmutableSet.of();
            }
            CFANode node = blockState.getLocationNode();
            return CFAUtils.successorsOf(node).filter(n -> this.nodes.contains(n)).transform(n -> new BlockState((CFANode)n, this.bNode, AnalysisDirection.FORWARD, this.getType((CFANode)n), this.hasLoopHeadEncountered(blockState))).toList();
        }
    }
}

