/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.cache;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.cpa.cache.CacheMergeOperator;
import org.sosy_lab.cpachecker.cpa.cache.CachePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.cache.CacheTransferRelation;

public class CacheCPA
implements ConfigurableProgramAnalysis,
WrapperCPA {
    private final ConfigurableProgramAnalysis mCachedCPA;
    private final Map<CFANode, AbstractState> mInitialStatesCache;
    private final Map<CFANode, Precision> mInitialPrecisionsCache;
    private final CacheTransferRelation mCacheTransferRelation;
    private final CachePrecisionAdjustment mCachePrecisionAdjustment;
    private final CacheMergeOperator mCacheMergeOperator;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(CacheCPA.class);
    }

    public CacheCPA(ConfigurableProgramAnalysis pCachedCPA) {
        this.mCachedCPA = pCachedCPA;
        this.mInitialStatesCache = new HashMap<CFANode, AbstractState>();
        this.mInitialPrecisionsCache = new HashMap<CFANode, Precision>();
        this.mCacheTransferRelation = new CacheTransferRelation(this.mCachedCPA.getTransferRelation());
        this.mCachePrecisionAdjustment = new CachePrecisionAdjustment(this.mCachedCPA.getPrecisionAdjustment());
        this.mCacheMergeOperator = new CacheMergeOperator(this.mCachedCPA.getMergeOperator());
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.mCachedCPA.getAbstractDomain();
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.mCacheTransferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mCacheMergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.mCachedCPA.getStopOperator();
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.mCachePrecisionAdjustment;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        AbstractState lInitialState = this.mInitialStatesCache.get(pNode);
        if (lInitialState == null) {
            lInitialState = this.mCachedCPA.getInitialState(pNode, pPartition);
            this.mInitialStatesCache.put(pNode, lInitialState);
        }
        return lInitialState;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        Precision lInitialPrecision = this.mInitialPrecisionsCache.get(pNode);
        if (lInitialPrecision == null) {
            lInitialPrecision = this.mCachedCPA.getInitialPrecision(pNode, pPartition);
            this.mInitialPrecisionsCache.put(pNode, lInitialPrecision);
        }
        return lInitialPrecision;
    }

    @Override
    public <T extends ConfigurableProgramAnalysis> T retrieveWrappedCpa(Class<T> pType) {
        if (pType.isAssignableFrom(this.getClass())) {
            return (T)((ConfigurableProgramAnalysis)pType.cast(this));
        }
        if (pType.isAssignableFrom(this.mCachedCPA.getClass())) {
            return (T)((ConfigurableProgramAnalysis)pType.cast(this.mCachedCPA));
        }
        if (this.mCachedCPA instanceof WrapperCPA) {
            return ((WrapperCPA)((Object)this.mCachedCPA)).retrieveWrappedCpa(pType);
        }
        return null;
    }

    public ImmutableList<ConfigurableProgramAnalysis> getWrappedCPAs() {
        return ImmutableList.of((Object)this.mCachedCPA);
    }
}

