/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.cache;

import com.google.common.base.Function;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class CachePrecisionAdjustment
implements PrecisionAdjustment {
    private final PrecisionAdjustment mCachedPrecisionAdjustment;
    private final Map<Precision, Map<AbstractState, Optional<PrecisionAdjustmentResult>>> mCache;

    public CachePrecisionAdjustment(PrecisionAdjustment pCachedPrecisionAdjustment) {
        this.mCachedPrecisionAdjustment = pCachedPrecisionAdjustment;
        this.mCache = new HashMap<Precision, Map<AbstractState, Optional<PrecisionAdjustmentResult>>>();
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pElement, Precision pPrecision, UnmodifiableReachedSet pElements, Function<AbstractState, AbstractState> projection, AbstractState fullState) throws CPAException, InterruptedException {
        Optional<PrecisionAdjustmentResult> lResult;
        Map<AbstractState, Optional<PrecisionAdjustmentResult>> lCache = this.mCache.get(pPrecision);
        if (lCache == null) {
            lCache = new HashMap<AbstractState, Optional<PrecisionAdjustmentResult>>();
            this.mCache.put(pPrecision, lCache);
        }
        if ((lResult = lCache.get(pElement)) == null) {
            lResult = this.mCachedPrecisionAdjustment.prec(pElement, pPrecision, pElements, projection, fullState);
            lCache.put(pElement, lResult);
        }
        return lResult;
    }
}

