/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class CacheTransferRelation
extends SingleEdgeTransferRelation {
    private final TransferRelation mCachedTransferRelation;
    private Map<Precision, Map<CFAEdge, Map<AbstractState, Collection<? extends AbstractState>>>> mSuccessorsCache;

    public CacheTransferRelation(TransferRelation pCachedTransferRelation) {
        this.mCachedTransferRelation = pCachedTransferRelation;
        this.mSuccessorsCache = new HashMap<Precision, Map<CFAEdge, Map<AbstractState, Collection<? extends AbstractState>>>>();
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        Collection<? extends AbstractState> lSuccessors;
        Map<AbstractState, Collection<? extends AbstractState>> lLevel2Cache;
        Map<CFAEdge, Map<AbstractState, Collection<? extends AbstractState>>> lLevel1Cache = this.mSuccessorsCache.get(pPrecision);
        if (lLevel1Cache == null) {
            lLevel1Cache = new HashMap<CFAEdge, Map<AbstractState, Collection<? extends AbstractState>>>();
            this.mSuccessorsCache.put(pPrecision, lLevel1Cache);
        }
        if ((lLevel2Cache = lLevel1Cache.get(pCfaEdge)) == null) {
            lLevel2Cache = new HashMap<AbstractState, Collection<? extends AbstractState>>();
            lLevel1Cache.put(pCfaEdge, lLevel2Cache);
        }
        if ((lSuccessors = lLevel2Cache.get(pElement)) == null) {
            lSuccessors = this.mCachedTransferRelation.getAbstractSuccessorsForEdge(pElement, pPrecision, pCfaEdge);
            lLevel2Cache.put(pElement, lSuccessors);
        }
        return lSuccessors;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pElement, Iterable<AbstractState> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        return this.mCachedTransferRelation.strengthen(pElement, pOtherElements, pCfaEdge, pPrecision);
    }
}

