/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.callstack;

import java.util.Collection;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackOptions;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackPCCAbstractDomain;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackReducer;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackStateEqualsWrapper;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackTransferRelation;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackTransferRelationBackwards;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class CallstackCPA
extends AbstractCPA
implements ConfigurableProgramAnalysisWithBAM,
ProofChecker {
    private final CallstackOptions options;
    private final LogManager logger;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(CallstackCPA.class);
    }

    public CallstackCPA(Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        super("sep", "sep", null);
        this.logger = pLogger;
        this.options = new CallstackOptions(config);
    }

    @Override
    public Reducer getReducer() {
        return new CallstackReducer();
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return new CallstackState(null, pNode.getFunctionName(), pNode);
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        Collection<? extends AbstractState> computedSuccessors = this.getTransferRelation().getAbstractSuccessorsForEdge(pElement, SingletonPrecision.getInstance(), pCfaEdge);
        if (!(pSuccessors instanceof Set) || !(computedSuccessors instanceof Set) || pSuccessors.size() != computedSuccessors.size()) {
            return false;
        }
        for (AbstractState abstractState : pSuccessors) {
            boolean found = false;
            for (AbstractState abstractState2 : computedSuccessors) {
                if (!((CallstackState)abstractState).sameStateInProofChecking((CallstackState)abstractState2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCoveredBy(AbstractState pElement, AbstractState pOtherElement) throws CPAException, InterruptedException {
        return this.getAbstractDomain().isLessOrEqual(pElement, pOtherElement) || ((CallstackState)pElement).sameStateInProofChecking((CallstackState)pOtherElement);
    }

    @Override
    public boolean isCoveredByRecursiveState(AbstractState state1, AbstractState state2) throws CPAException, InterruptedException {
        return new CallstackStateEqualsWrapper((CallstackState)state1).equals(new CallstackStateEqualsWrapper((CallstackState)state2));
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        switch (this.options.getDomainType()) {
            case "FLAT": {
                return new FlatLatticeDomain();
            }
            case "FLATPCC": {
                return new CallstackPCCAbstractDomain();
            }
        }
        throw new AssertionError((Object)"Unknown domain type for callstack cpa.");
    }

    @Override
    public CallstackTransferRelation getTransferRelation() {
        if (this.options.traverseBackwards()) {
            return new CallstackTransferRelationBackwards(this.options, this.logger);
        }
        return new CallstackTransferRelation(this.options, this.logger);
    }
}

