/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.callstack;

import com.google.common.collect.ImmutableSet;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;

@Options(prefix="cpa.callstack")
class CallstackOptions {
    @Option(secure=true, description="Blacklist of extern functions that will make the analysis abort if called")
    private ImmutableSet<String> unsupportedFunctions = ImmutableSet.of((Object)"pthread_create", (Object)"pthread_key_create", (Object)"longjmp", (Object)"siglongjmp", (Object)"__builtin_va_arg", (Object)"atexit", (Object[])new String[0]);
    @Option(secure=true, name="depth", description="depth of recursion bound")
    private int recursionBoundDepth = 0;
    @Option(secure=true, name="skipRecursion", description="Skip recursion (this is unsound). Treat function call as a statement (the same as for functions without bodies)")
    private boolean skipRecursion = false;
    @Option(secure=true, description="Skip recursion if it happens only by going via a function pointer (this is unsound). Imprecise function pointer tracking often lead to false recursions.")
    private boolean skipFunctionPointerRecursion = false;
    @Option(secure=true, description="Skip recursion if it happens only by going via a void function (this is unsound).")
    private boolean skipVoidRecursion = false;
    @Option(description="analyse the CFA backwards", secure=true)
    private boolean traverseBackwards = false;
    @Option(secure=true, name="domain", toUppercase=true, values={"FLAT", "FLATPCC"}, description="which abstract domain to use for callstack cpa, typically FLAT which is faster since it uses only object equivalence")
    private String domainType = "FLAT";

    CallstackOptions(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
    }

    ImmutableSet<String> getUnsupportedFunctions() {
        return this.unsupportedFunctions;
    }

    int getRecursionBoundDepth() {
        return this.recursionBoundDepth;
    }

    boolean skipRecursion() {
        return this.skipRecursion;
    }

    boolean skipFunctionPointerRecursion() {
        return this.skipFunctionPointerRecursion;
    }

    boolean skipVoidRecursion() {
        return this.skipVoidRecursion;
    }

    boolean traverseBackwards() {
        return this.traverseBackwards;
    }

    String getDomainType() {
        return this.domainType;
    }
}

