/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.callstack;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.io.TempFile;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.test.CPATestRunner;
import org.sosy_lab.cpachecker.util.test.TestDataTools;
import org.sosy_lab.cpachecker.util.test.TestResults;

public class CallstackTest {
    @Test
    public void testCallstackPreventsUndesiredCoverage() throws Exception {
        ImmutableList program = ImmutableList.of((Object)"extern int __VERIFIER_nondet_int();", (Object)"int global;", (Object)"", (Object)"void init() {", (Object)"  global = __VERIFIER_nondet_int() ? 1 : 2;", (Object)"}", (Object)"", (Object)"void f() {", (Object)"  global = 3;", (Object)"}", (Object)"", (Object)"void main() {", (Object[])new String[]{"  init();", "  f();", "}"});
        try (TempFile.DeleteOnCloseFile programFile = TempFile.builder().prefix("test").suffix(".c").createDeleteOnClose();){
            Files.write(programFile.toPath(), (Iterable<? extends CharSequence>)program, new OpenOption[0]);
            Configuration config = TestDataTools.configurationForTest().setOption("cpa", "cpa.arg.ARGCPA").setOption("ARGCPA.cpa", "cpa.composite.CompositeCPA").setOption("CompositeCPA.cpas", "cpa.location.LocationCPA, cpa.callstack.CallstackCPA, cpa.value.ValueAnalysisCPA").build();
            TestResults result = CPATestRunner.run(config, programFile.toPath().toString());
            result.assertIsSafe();
            FluentIterable argStates = FluentIterable.from((Iterable)result.getCheckerResult().getReached()).filter(ARGState.class);
            Truth.assert_().withMessage("unexpected merged").that((Iterable)argStates.filter(s -> s.getParents().size() > 1)).isEmpty();
            ImmutableList coveredStates = argStates.transformAndConcat(s -> s.getCoveredByThis()).toList();
            Truth.assert_().withMessage("exactly one covered state expected").that((Iterable)coveredStates).hasSize(1);
            CFANode coverageLocation = AbstractStates.extractLocation((AbstractState)coveredStates.get(0));
            Truth.assert_().withMessage("expected coverage only in main").that(coverageLocation.getFunctionName()).isEqualTo((Object)"main");
            Truth.assert_().withMessage("expected coverage right after return from f").that((Object)coverageLocation.getEnteringSummaryEdge()).isNotNull();
        }
    }
}

