/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.callstack;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CThreadOperationStatement;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackOptions;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class CallstackTransferRelation
extends SingleEdgeTransferRelation {
    private boolean isRecursiveContext = false;
    protected final CallstackOptions options;
    protected final LogManagerWithoutDuplicates logger;

    public CallstackTransferRelation(CallstackOptions pOptions, LogManager pLogger) {
        this.options = pOptions;
        this.logger = new LogManagerWithoutDuplicates(pLogger);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pElement, Precision pPrecision, CFAEdge pEdge) throws CPATransferException {
        CallstackState e = (CallstackState)pElement;
        CFANode pred = pEdge.getPredecessor();
        CFANode succ = pEdge.getSuccessor();
        String predFunction = pred.getFunctionName();
        String succFunction = succ.getFunctionName();
        switch (pEdge.getEdgeType()) {
            case StatementEdge: {
                AExpression functionNameExp;
                AStatementEdge edge = (AStatementEdge)pEdge;
                if (edge.getStatement() instanceof AFunctionCall && (functionNameExp = ((AFunctionCall)edge.getStatement()).getFunctionCallExpression().getFunctionNameExpression()) instanceof AIdExpression) {
                    String functionName = ((AIdExpression)functionNameExp).getName();
                    if (this.options.getUnsupportedFunctions().contains((Object)functionName)) {
                        throw new UnsupportedCodeException(functionName, edge, edge.getStatement());
                    }
                }
                if (!(pEdge instanceof CFunctionSummaryStatementEdge) || this.shouldGoByFunctionSummaryStatement(e, (CFunctionSummaryStatementEdge)pEdge)) break;
                return ImmutableSet.of();
            }
            case FunctionCallEdge: {
                String calledFunction = succ.getFunctionName();
                CFANode callerNode = pred;
                if (this.hasRecursion(e, calledFunction)) {
                    if (this.skipRecursiveFunctionCall(e, (FunctionCallEdge)pEdge)) {
                        this.logger.logOnce(Level.WARNING, new Object[]{"Skipping recursive function call from", pred.getFunctionName(), "to", calledFunction});
                        return ImmutableSet.of();
                    }
                    this.logger.log(Level.INFO, new Object[]{"Recursion detected, aborting. To ignore recursion, add -skipRecursion to the command line."});
                    throw new UnsupportedCodeException("recursion", pEdge);
                }
                return ImmutableSet.of((Object)new CallstackState(e, calledFunction, callerNode));
            }
            case FunctionReturnEdge: {
                CallstackState returnElement;
                String calledFunction = predFunction;
                String callerFunction = succFunction;
                CFANode callNode = succ.getEnteringSummaryEdge().getPredecessor();
                assert (calledFunction.equals(e.getCurrentFunction()) || this.isWildcardState(e, AnalysisDirection.FORWARD)) : String.format("not in scope of called function \"%s\" when leaving function \"%s\" in state \"%s\"", calledFunction, e.getCurrentFunction(), e);
                if (this.isWildcardState(e, AnalysisDirection.FORWARD)) {
                    returnElement = new CallstackState(null, callerFunction, e.getCallNode());
                } else {
                    if (!callNode.equals(e.getCallNode())) {
                        return ImmutableSet.of();
                    }
                    returnElement = e.getPreviousState();
                    assert (callerFunction.equals(returnElement.getCurrentFunction()) || this.isWildcardState(returnElement, AnalysisDirection.FORWARD)) : String.format("calling function \"%s\" not available after function return into function scope \"%s\" in state \"%s\"", callerFunction, returnElement.getCurrentFunction(), returnElement);
                }
                return Collections.singleton(returnElement);
            }
        }
        return Collections.singleton(pElement);
    }

    protected boolean isWildcardState(CallstackState pState, AnalysisDirection direction) {
        String function = pState.getCurrentFunction();
        CFANode callNode = pState.getCallNode();
        if (callNode instanceof FunctionEntryNode && callNode.getFunctionName().equals(function)) {
            return false;
        }
        for (FunctionEntryNode node : CFAUtils.successorsOf(pState.getCallNode()).filter(FunctionEntryNode.class)) {
            if (!node.getFunctionName().equals(pState.getCurrentFunction())) continue;
            return false;
        }
        return direction == AnalysisDirection.FORWARD;
    }

    protected boolean skipRecursiveFunctionCall(CallstackState element, FunctionCallEdge callEdge) {
        if (CFAUtils.leavingEdges(callEdge.getPredecessor()).filter(CFunctionSummaryStatementEdge.class).isEmpty()) {
            return false;
        }
        if (this.options.skipRecursion()) {
            return true;
        }
        if (this.options.skipFunctionPointerRecursion() && this.hasFunctionPointerRecursion(element, callEdge)) {
            return true;
        }
        return this.options.skipVoidRecursion() && this.hasVoidRecursion(element, callEdge);
    }

    protected boolean hasRecursion(CallstackState pCurrentState, String pCalledFunction) {
        if (this.isRecursiveContext) {
            return true;
        }
        int counter = 0;
        for (CallstackState e = pCurrentState; e != null; e = e.getPreviousState()) {
            if (!e.getCurrentFunction().equals(pCalledFunction) || ++counter <= this.options.getRecursionBoundDepth()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasFunctionPointerRecursion(CallstackState element, FunctionCallEdge pCallEdge) {
        if (pCallEdge.getRawStatement().startsWith("pointer call(")) {
            return true;
        }
        String functionName = pCallEdge.getSuccessor().getFunctionName();
        for (CallstackState e = element; e != null; e = e.getPreviousState()) {
            if (e.getCurrentFunction().equals(functionName)) {
                return false;
            }
            if (e.getPreviousState() == null) {
                return false;
            }
            FunctionCallEdge callEdge = this.findOutgoingCallEdge(e.getCallNode());
            if (!callEdge.getRawStatement().startsWith("pointer call(")) continue;
            return true;
        }
        throw new AssertionError();
    }

    protected boolean hasVoidRecursion(CallstackState element, FunctionCallEdge pCallEdge) {
        if (pCallEdge.getSummaryEdge().getExpression() instanceof AFunctionCallStatement) {
            return true;
        }
        String functionName = pCallEdge.getSuccessor().getFunctionName();
        for (CallstackState e = element; e != null; e = e.getPreviousState()) {
            if (e.getCurrentFunction().equals(functionName)) {
                return false;
            }
            if (e.getPreviousState() == null) {
                return false;
            }
            FunctionSummaryEdge summaryEdge = e.getCallNode().getLeavingSummaryEdge();
            if (!(summaryEdge.getExpression() instanceof AFunctionCallStatement)) continue;
            return true;
        }
        throw new AssertionError();
    }

    protected boolean shouldGoByFunctionSummaryStatement(CallstackState element, CFunctionSummaryStatementEdge sumEdge) {
        String functionName = sumEdge.getFunctionName();
        FunctionCallEdge callEdge = this.findOutgoingCallEdge(sumEdge.getPredecessor());
        if (sumEdge.getFunctionCall() instanceof CThreadOperationStatement.CThreadCreateStatement) {
            return true;
        }
        assert (functionName.equals(callEdge.getSuccessor().getFunctionName()));
        return this.hasRecursion(element, functionName) && this.skipRecursiveFunctionCall(element, callEdge);
    }

    protected FunctionCallEdge findOutgoingCallEdge(CFANode predNode) {
        for (CFAEdge edge : CFAUtils.leavingEdges(predNode)) {
            if (edge.getEdgeType() != CFAEdgeType.FunctionCallEdge) continue;
            return (FunctionCallEdge)edge;
        }
        throw new AssertionError((Object)("Missing function call edge for function call summary edge after node " + predNode));
    }

    public void enableRecursiveContext() {
        this.isRecursiveContext = true;
    }

    public void disableRecursiveContext() {
        this.isRecursiveContext = false;
    }
}

