/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.callstack;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackOptions;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class CallstackTransferRelationBackwards
extends CallstackTransferRelation {
    public CallstackTransferRelationBackwards(CallstackOptions pOptions, LogManager pLogger) {
        super(pOptions, pLogger);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pElement, Precision pPrecision, CFAEdge pEdge) throws CPATransferException {
        CallstackState e = (CallstackState)pElement;
        CFANode nextAnalysisLoc = pEdge.getPredecessor();
        CFANode prevAnalysisLoc = pEdge.getSuccessor();
        String prevAnalysisFunction = prevAnalysisLoc.getFunctionName();
        String nextAnalysisFunction = nextAnalysisLoc.getFunctionName();
        switch (pEdge.getEdgeType()) {
            case StatementEdge: {
                AExpression functionNameExp;
                AStatementEdge edge = (AStatementEdge)pEdge;
                if (edge.getStatement() instanceof AFunctionCall && (functionNameExp = ((AFunctionCall)edge.getStatement()).getFunctionCallExpression().getFunctionNameExpression()) instanceof AIdExpression) {
                    String functionName = ((AIdExpression)functionNameExp).getName();
                    if (this.options.getUnsupportedFunctions().contains((Object)functionName)) {
                        throw new UnrecognizedCodeException("Unsupported feature: " + this.options.getUnsupportedFunctions(), edge, edge.getStatement());
                    }
                }
                if (!(pEdge instanceof CFunctionSummaryStatementEdge) || this.shouldGoByFunctionSummaryStatement(e, (CFunctionSummaryStatementEdge)pEdge)) break;
                return ImmutableSet.of();
            }
            case FunctionReturnEdge: {
                FunctionReturnEdge edge = (FunctionReturnEdge)pEdge;
                CFANode correspondingCallNode = edge.getSummaryEdge().getPredecessor();
                if (this.hasRecursion(e, nextAnalysisFunction)) {
                    if (this.options.skipRecursion()) {
                        this.logger.logOnce(Level.WARNING, new Object[]{"Skipping recursive function call from", prevAnalysisFunction, "to", nextAnalysisFunction});
                        return ImmutableSet.of();
                    }
                    this.logger.log(Level.INFO, new Object[]{"Recursion detected, aborting. To ignore recursion, add -skipRecursion to the command line."});
                    throw new UnsupportedCodeException("recursion", pEdge);
                }
                return ImmutableSet.of((Object)new CallstackState(e, nextAnalysisFunction, correspondingCallNode));
            }
            case FunctionCallEdge: {
                if (this.isWildcardState(e, AnalysisDirection.BACKWARD)) {
                    throw new UnsupportedCodeException("ARTIFICIAL_PROGRAM_COUNTER not yet supported for the backwards analysis!", pEdge);
                }
                CallstackState nextStackState = e.getPreviousState();
                Object result = nextStackState == null ? ImmutableSet.of((Object)new CallstackState(null, nextAnalysisFunction, nextAnalysisLoc)) : (e.getCallNode().equals(nextAnalysisLoc) ? Collections.singleton(nextStackState) : ImmutableSet.of());
                return result;
            }
        }
        return Collections.singleton(pElement);
    }

    @Override
    protected FunctionCallEdge findOutgoingCallEdge(CFANode predNode) {
        for (CFAEdge edge : CFAUtils.leavingEdges(predNode)) {
            if (edge.getEdgeType() != CFAEdgeType.FunctionCallEdge) continue;
            return (FunctionCallEdge)edge;
        }
        throw new AssertionError((Object)"Missing function call edge for function call summary edge");
    }
}

