/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.chc;

import com.google.common.base.Function;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.chc.CHCState;
import org.sosy_lab.cpachecker.cpa.chc.ConstraintManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class CHCPrecisionAdjustment
implements PrecisionAdjustment {
    private final LogManager logger;

    public CHCPrecisionAdjustment(LogManager logM) {
        this.logger = logM;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState successor, Precision precision, UnmodifiableReachedSet states, Function<AbstractState, AbstractState> projection, AbstractState fullState) throws CPAException {
        CHCState candidateState = (CHCState)successor;
        CHCState ancestor = this.findVariantAncestor(candidateState);
        if (ancestor != null) {
            AbstractState newState = this.generalize(candidateState, ancestor);
            return Optional.of(PrecisionAdjustmentResult.create(newState, precision, PrecisionAdjustmentResult.Action.CONTINUE));
        }
        return Optional.of(PrecisionAdjustmentResult.create(successor, precision, PrecisionAdjustmentResult.Action.CONTINUE));
    }

    private CHCState findVariantAncestor(CHCState candidateState) {
        for (CHCState variantAncestor = candidateState.getAncestor(); variantAncestor != null; variantAncestor = variantAncestor.getAncestor()) {
            if (variantAncestor.getNodeId() != candidateState.getNodeId()) continue;
            this.logger.log(Level.FINEST, new Object[]{"\n * variant found: " + variantAncestor});
            return variantAncestor;
        }
        return null;
    }

    private AbstractState generalize(CHCState reachedState, CHCState ancestor) {
        CHCState gState = new CHCState();
        gState.setConstraint(ConstraintManager.generalize(ancestor.getConstraint(), reachedState.getConstraint()));
        return gState;
    }
}

