/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.chc;

import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.chc.Constraint;
import org.sosy_lab.cpachecker.cpa.chc.ConstraintManager;

public class CHCState
implements AbstractState {
    int nodeNumber;
    Constraint constraint = null;
    CHCState ancestor = null;
    CHCState caller = null;

    public CHCState() {
        this.nodeNumber = 0;
        this.constraint = new Constraint();
        this.caller = this;
    }

    public CHCState(int nodeId, Constraint constraint) {
        this.nodeNumber = nodeId;
        this.constraint = constraint;
        this.caller = this;
    }

    public CHCState(CHCState crState) {
        this.nodeNumber = crState.nodeNumber;
        this.constraint = new Constraint(crState.getConstraint());
        this.ancestor = crState;
        this.caller = crState.getCaller();
    }

    public void setNodeNumber(int nodeId) {
        this.nodeNumber = nodeId;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public void setAncestror(CHCState ancestor) {
        this.ancestor = ancestor;
    }

    public void setCaller(CHCState caller) {
        this.caller = caller;
    }

    public int getNodeId() {
        return this.nodeNumber;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public CHCState getAncestor() {
        return this.ancestor;
    }

    public CHCState getCaller() {
        return this.caller;
    }

    public void updateConstraint(Constraint cns) {
        this.constraint = ConstraintManager.and(this.constraint, cns);
    }

    public void addConstraint(Constraint cns) {
        this.constraint.and(cns);
    }

    public void join(CHCState state1) {
        this.constraint = ConstraintManager.convexHull(this.constraint, state1.getConstraint());
    }

    public boolean isBottom() {
        return this.constraint.isFalse();
    }

    @Override
    public String toString() {
        return this.constraint.toString();
    }
}

