/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.chc;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jpl.Term;
import org.sosy_lab.cpachecker.cpa.chc.ConstraintManager;

public class Constraint {
    private List<Term> cns = null;
    private Map<String, Term> vars = null;

    public Constraint() {
        this.cns = new ArrayList<Term>();
        this.vars = new HashMap<String, Term>();
    }

    public Constraint(Constraint cn) {
        this.cns = new ArrayList<Term>(cn.getConstraint());
        this.vars = new HashMap<String, Term>(cn.getVars());
    }

    public Constraint(List<Term> cns, Map<String, Term> vars) {
        this.cns = cns;
        this.vars = vars;
    }

    public Constraint(List<Term> cns) {
        this.cns = cns;
        this.vars = new HashMap<String, Term>();
    }

    public Constraint(List<Term> cns, List<Term> vars) {
        this.cns = cns;
        this.createHashMap(vars);
    }

    public Constraint(Term cn, List<Term> vars) {
        this.cns = new ArrayList<Term>();
        this.cns.add(cn);
        this.createHashMap(vars);
    }

    public void addAtomicConstraint(Term t) {
        this.cns.add(t);
    }

    public void addVar(String var, Term t) {
        this.vars.put(var, t);
    }

    public void addVars(HashMap<String, Term> pVars) {
        this.vars.putAll(pVars);
    }

    public void removeVar(String var) {
        this.vars.remove(var);
    }

    public String toString() {
        if (this.cns == null) {
            return "false";
        }
        if (this.cns.isEmpty()) {
            return "true";
        }
        return this.cns + " (vars: " + this.vars + ")";
    }

    public List<Term> getConstraint() {
        return this.cns;
    }

    public Map<String, Term> getVars() {
        return this.vars;
    }

    public boolean isTrue() {
        return this.cns.isEmpty();
    }

    public boolean isFalse() {
        if (this.cns == null) {
            return true;
        }
        return !this.cns.isEmpty() && this.cns.get(0).toString().equals("false");
    }

    public static boolean isFalse(String cr) {
        return cr.equals("'.'(false, [])");
    }

    public void setTrue() {
        this.cns = new ArrayList<Term>();
    }

    @CanIgnoreReturnValue
    public Constraint setFalse() {
        this.cns = null;
        return this;
    }

    public void and(Constraint cn) {
        this.cns.addAll(cn.getConstraint());
    }

    @CanIgnoreReturnValue
    public Constraint setConstraint(List<Term> cns) {
        this.cns = cns;
        return this;
    }

    public void emptyVar() {
        this.vars = new HashMap<String, Term>();
    }

    private void createHashMap(List<Term> varTerms) {
        this.vars = new HashMap<String, Term>();
        for (Term v : varTerms) {
            this.vars.put(ConstraintManager.var2CVar(v.name()), v);
        }
    }
}

