/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.chc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import jpl.Compound;
import jpl.JPL;
import jpl.Query;
import jpl.Term;
import jpl.Util;
import jpl.Variable;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cpa.chc.Constraint;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.Pair;

public class ConstraintManager {
    private static LogManager logger;

    public static boolean init(String firingRelation, String generalizationOperator, LogManager logM) {
        String[] initstr = new String[]{"swipl", "-x", NativeLibraries.getNativeLibraryPath().resolve("chc_lib").toString(), "-g", "true", "-nosignals"};
        boolean init = JPL.init((String[])initstr);
        ConstraintManager.initFiringRelation(firingRelation);
        ConstraintManager.initGeneralizationOperator(generalizationOperator);
        logger = logM;
        return init;
    }

    public static Constraint simplify(List<Term> cn, Map<String, Term> vars) {
        Term constraint = Util.termArrayToList((Term[])cn.toArray(new Term[0]));
        Term varList = Util.termArrayToList((Term[])vars.values().toArray(new Term[0]));
        Term[] args = new Term[]{constraint, varList, new Variable("S")};
        Query q = new Query("solve", args);
        logger.log(Level.FINEST, new Object[]{"\n * solve (w.r.t. " + varList + ")"});
        Hashtable sol = q.oneSolution();
        return ConstraintManager.normalize("S", sol);
    }

    public static boolean subsumes(Constraint cn1, Constraint cn2) {
        Term constraint1 = Util.termArrayToList((Term[])cn1.getConstraint().toArray(new Term[0]));
        Term constraint2 = Util.termArrayToList((Term[])cn2.getConstraint().toArray(new Term[0]));
        Term[] args = new Term[]{constraint1, constraint2};
        Query q = new Query("entails", args);
        logger.log(Level.FINEST, new Object[]{"\n * " + cn1 + "\n * entails\n * " + cn2 + ")"});
        boolean res = q.hasSolution();
        logger.log(Level.FINEST, new Object[]{"\n * result: " + res});
        return res;
    }

    public static Constraint generalize(Constraint cn1, Constraint cn2) {
        Term constraint1 = Util.termArrayToList((Term[])cn1.getConstraint().toArray(new Term[0]));
        Term constraint2 = Util.termArrayToList((Term[])cn2.getConstraint().toArray(new Term[0]));
        Term[] args = new Term[]{constraint1, constraint2, new Variable("G")};
        Query q = new Query("generalize", args);
        logger.log(Level.FINEST, new Object[]{"\n * definition: " + cn1 + "\n * ancestor :  " + cn1});
        return ConstraintManager.normalize("G", q.oneSolution());
    }

    public static Constraint and(Constraint cn1, Constraint cn2) {
        ArrayList<Term> andCn = new ArrayList<Term>(cn1.getConstraint());
        andCn.addAll(cn2.getConstraint());
        logger.log(Level.FINEST, new Object[]{"\n * " + cn1 + "\n * and \n * " + cn2});
        Map<String, Term> newVars = ConstraintManager.selectVariables(cn1.getVars(), cn2.getVars());
        Constraint andConstraint = ConstraintManager.simplify(andCn, newVars);
        logger.log(Level.FINEST, new Object[]{"\n * " + andConstraint});
        return andConstraint;
    }

    private static Map<String, Term> selectVariables(Map<String, Term> vars, Map<String, Term> pVars) {
        HashMap<String, Term> newVars = new HashMap<String, Term>(pVars);
        for (Map.Entry<String, Term> me : vars.entrySet()) {
            if (pVars.containsKey(me.getKey())) continue;
            newVars.put(me.getKey(), me.getValue());
        }
        return newVars;
    }

    private static Constraint normalize(String sol, Map<String, Term> varMap) {
        Term cn = varMap.get(sol);
        String newConstraint = cn.toString();
        Constraint nres = new Constraint();
        if (Constraint.isFalse(newConstraint)) {
            return nres.setFalse();
        }
        HashMap<String, Term> varSolMap = new HashMap<String, Term>(varMap);
        varSolMap.remove(sol);
        for (Map.Entry me : varSolMap.entrySet()) {
            newConstraint = newConstraint.replace(((Term)me.getValue()).toString(), ConstraintManager.primedVarToVar((String)me.getKey()));
            nres.addVar(ConstraintManager.var2CVar(ConstraintManager.primedVarToVar((String)me.getKey())), (Term)new Variable(ConstraintManager.primedVarToVar((String)me.getKey())));
        }
        nres.setConstraint(new ArrayList<Term>(Arrays.asList(Util.listToTermArray((Term)Util.textToTerm((String)newConstraint)))));
        logger.log(Level.FINEST, new Object[]{"\n * result: " + nres});
        return nres;
    }

    public static List<Constraint> getConstraint(AssumeEdge ae) {
        CBinaryExpression c = (CBinaryExpression)ae.getExpression();
        ArrayList<Constraint> cns = new ArrayList<Constraint>(2);
        if (ae.getTruthAssumption()) {
            Collection<Pair<Term, List<Term>>> acList = ConstraintManager.expressionToCLP(c);
            for (Pair<Term, List<Term>> p : acList) {
                cns.add(new Constraint(p.getFirst(), p.getSecond()));
            }
        } else {
            CBinaryExpression negbe = null;
            if (c.getOperator().isLogicalOperator()) {
                negbe = new CBinaryExpression(c.getFileLocation(), c.getExpressionType(), c.getCalculationType(), c.getOperand1(), c.getOperand2(), c.getOperator().getOppositLogicalOperator());
            }
            Collection<Pair<Term, List<Term>>> acList = ConstraintManager.expressionToCLP(negbe);
            for (Pair<Term, List<Term>> p : acList) {
                cns.add(new Constraint(p.getFirst(), p.getSecond()));
            }
        }
        return cns;
    }

    public static Constraint getConstraint(CAssignment ca) {
        Constraint c = new Constraint();
        CLeftHandSide lhs = ca.getLeftHandSide();
        CRightHandSide rhs = ca.getRightHandSide();
        CExpression exp = (CExpression)rhs;
        c.addVar(lhs.toString(), (Term)ConstraintManager.CVar2PrologPrimedVar(lhs.toString()));
        if (lhs instanceof AIdExpression) {
            for (Pair<Term, List<Term>> t : ConstraintManager.expressionToCLP(exp)) {
                Term[] operands = new Term[]{c.getVars().get(lhs.toString()), t.getFirst()};
                ArrayList<Term> list = new ArrayList<Term>();
                list.add((Term)new Compound("=:=", operands));
                c.setConstraint(list);
            }
        } else {
            throw new AssertionError((Object)("unhandled assignment " + ca));
        }
        return c;
    }

    public static Constraint getConstraint(CExpression exp) {
        ArrayList<Term> tlist = new ArrayList<Term>();
        ArrayList<Term> vlist = new ArrayList<Term>();
        for (Pair<Term, List<Term>> t : ConstraintManager.expressionToCLP(exp)) {
            tlist.add(t.getFirst());
            vlist.addAll((Collection<Term>)t.getSecond());
        }
        return new Constraint(tlist, vlist);
    }

    public static List<Constraint> getConstraint(List<CExpression> exp) {
        ArrayList<Constraint> clist = new ArrayList<Constraint>();
        for (CExpression c : exp) {
            clist.add(ConstraintManager.getConstraint(c));
        }
        return clist;
    }

    public static Constraint getConstraint(ADeclarationEdge ae) {
        CDeclaration decl = (CDeclaration)ae.getDeclaration();
        Constraint ac = new Constraint();
        if (decl instanceof CVariableDeclaration) {
            CVariableDeclaration vdecl = (CVariableDeclaration)decl;
            CInitializer initializer = vdecl.getInitializer();
            String varName = vdecl.getName();
            Variable lhs = ConstraintManager.CVar2PrologPrimedVar(varName);
            if (initializer != null && initializer instanceof CInitializerExpression) {
                CExpression expression = ((CInitializerExpression)initializer).getExpression();
                Collection<Pair<Term, List<Term>>> at = ConstraintManager.expressionToCLP(expression);
                for (Pair<Term, List<Term>> t : at) {
                    Term rhs = t.getFirst();
                    ArrayList<Term> acList = new ArrayList<Term>();
                    acList.add((Term)new Compound("=:=", new Term[]{lhs, rhs}));
                    ac.setConstraint(acList);
                }
            }
            ac.addVar(varName, (Term)lhs);
        }
        return ac;
    }

    public static Constraint getConstraint(AReturnStatementEdge aRetEdge) {
        CIntegerLiteralExpression expression = aRetEdge.getExpression().isPresent() ? aRetEdge.getExpression().get() : CIntegerLiteralExpression.ZERO;
        String varName = "FRET_" + aRetEdge.getSuccessor().getFunctionName();
        Variable lhs = ConstraintManager.CVar2PrologVar(varName);
        Constraint ac = new Constraint();
        Collection<Pair<Term, List<Term>>> at = ConstraintManager.expressionToCLP(expression);
        for (Pair<Term, List<Term>> t : at) {
            Term rhs = t.getFirst();
            ArrayList<Term> acList = new ArrayList<Term>();
            acList.add((Term)new Compound("=:=", new Term[]{lhs, rhs}));
            ac.setConstraint(acList);
        }
        ac.addVar(varName, (Term)lhs);
        return ac;
    }

    public static Constraint getConstraint(FunctionReturnEdge fretEdge) throws UnrecognizedCodeException {
        FunctionSummaryEdge summaryEdge = fretEdge.getSummaryEdge();
        AFunctionCall exprOnSummary = summaryEdge.getExpression();
        if (exprOnSummary instanceof AFunctionCallAssignmentStatement) {
            AFunctionCallAssignmentStatement assignExp = (AFunctionCallAssignmentStatement)exprOnSummary;
            ALeftHandSide op1 = assignExp.getLeftHandSide();
            if (op1 instanceof AIdExpression || op1 instanceof CFieldReference) {
                String varName = "FRET_" + fretEdge.getPredecessor().getFunctionName();
                Variable lhs = ConstraintManager.CVar2PrologPrimedVar(op1.toString());
                Variable rhs = ConstraintManager.CVar2PrologVar(varName);
                Constraint ac = new Constraint(Lists.newArrayList((Object[])new Term[]{new Compound("=:=", new Term[]{lhs, rhs})}));
                ac.addVar(op1.toString(), (Term)lhs);
                return ac;
            }
            if (op1 instanceof CArraySubscriptExpression) {
                return new Constraint();
            }
            throw new UnrecognizedCodeException("on function return", summaryEdge, null);
        }
        return new Constraint();
    }

    public static Constraint getConstraint(CExpression lhs, CFunctionCallExpression rhs) {
        Constraint c = new Constraint();
        if (rhs != null) {
            c.addVar(lhs.toString(), (Term)ConstraintManager.CVar2PrologPrimedVar(lhs.toString()));
            if (lhs instanceof AIdExpression) {
                Term[] operands = new Term[]{c.getVars().get(lhs.toString()), ConstraintManager.CVar2PrologVar(rhs.getFunctionNameExpression().toString())};
                ArrayList<Term> list = new ArrayList<Term>();
                list.add((Term)new Compound("=:=", operands));
                c.setConstraint(list);
            }
        }
        return c;
    }

    public static Collection<Constraint> getConstraint(List<String> names, List<? extends AExpression> expressions) {
        ArrayList<Constraint> cnList = new ArrayList<Constraint>();
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            AExpression expression = expressions.get(i);
            for (Pair<Term, List<Term>> p : ConstraintManager.paramExpressionToCLP(name, expression)) {
                cnList.add(new Constraint(new ArrayList<Term>(Arrays.asList(Util.listToTermArray((Term)p.getFirst()))), p.getSecond()));
            }
        }
        return cnList;
    }

    public static String var2CVar(String pv) {
        return pv.substring(4);
    }

    public static String primedVar2CVar(String ppv) {
        return ppv.substring(11);
    }

    public static Variable CVar2PrologVar(String cv) {
        return new Variable("CPA_" + cv);
    }

    public static Variable CVar2PrologPrimedVar(String cv) {
        return new Variable("Primed_CPA_" + cv);
    }

    private static String primedVarToVar(String pvar) {
        if (pvar.startsWith("Primed_")) {
            return pvar.replace("Primed_", "");
        }
        return pvar;
    }

    private static Collection<Pair<Term, List<Term>>> getNegatedConstraintList(Pair<Term, List<Term>> cn) {
        Compound atomCnT = (Compound)cn.getFirst();
        Compound negAtomCnT = null;
        switch (atomCnT.name()) {
            case "<": {
                negAtomCnT = new Compound(">=", 2);
                negAtomCnT.setArg(1, atomCnT.arg(1));
                negAtomCnT.setArg(2, atomCnT.arg(2));
                return ImmutableSet.of(Pair.of(negAtomCnT, cn.getSecond()));
            }
            case "=<": {
                negAtomCnT = new Compound(">", 2);
                negAtomCnT.setArg(1, atomCnT.arg(1));
                negAtomCnT.setArg(2, atomCnT.arg(2));
                return ImmutableSet.of(Pair.of(negAtomCnT, cn.getSecond()));
            }
            case ">": {
                negAtomCnT = new Compound("=<", 2);
                negAtomCnT.setArg(1, atomCnT.arg(1));
                negAtomCnT.setArg(2, atomCnT.arg(2));
                return ImmutableSet.of(Pair.of(negAtomCnT, cn.getSecond()));
            }
            case ">=": {
                negAtomCnT = new Compound("<", 2);
                negAtomCnT.setArg(1, atomCnT.arg(1));
                negAtomCnT.setArg(2, atomCnT.arg(2));
                return ImmutableSet.of(Pair.of(negAtomCnT, cn.getSecond()));
            }
            case "=:=": {
                return Arrays.asList(Pair.of(new Compound("<", new Term[]{atomCnT.arg(1), atomCnT.arg(2)}), cn.getSecond()), Pair.of(new Compound(">", new Term[]{atomCnT.arg(1), atomCnT.arg(2)}), cn.getSecond()));
            }
        }
        return null;
    }

    private static Collection<Pair<Term, List<Term>>> expressionToCLP(AExpression ce) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        if (ce instanceof CIdExpression) {
            vars.add(ConstraintManager.CVar2PrologVar(ce.toString()));
            return ImmutableSet.of(Pair.of(ConstraintManager.CVar2PrologVar(ce.toString()), vars));
        }
        if (ce instanceof CIntegerLiteralExpression) {
            return ImmutableSet.of(Pair.of(Util.textToTerm((String)("rdiv(" + ce + ",1)")), vars));
        }
        if (ce instanceof CBinaryExpression) {
            CBinaryExpression bexp = (CBinaryExpression)ce;
            Collection<Pair<Term, List<Term>>> operand1 = ConstraintManager.expressionToCLP(bexp.getOperand1());
            Collection<Pair<Term, List<Term>>> operand2 = ConstraintManager.expressionToCLP(bexp.getOperand2());
            switch (bexp.getOperator()) {
                case PLUS: {
                    return ConstraintManager.addOperands("+", operand1, operand2);
                }
                case MINUS: {
                    return ConstraintManager.addOperands("-", operand1, operand2);
                }
                case MULTIPLY: {
                    return ConstraintManager.addOperands("*", operand1, operand2);
                }
                case DIVIDE: {
                    return ConstraintManager.addOperands("/", operand1, operand2);
                }
                case EQUALS: {
                    return ConstraintManager.addOperands("=:=", operand1, operand2);
                }
                case NOT_EQUALS: {
                    ArrayList<Pair<Term, List<Term>>> opUnion = new ArrayList<Pair<Term, List<Term>>>(ConstraintManager.addOperands(">", operand1, operand2));
                    opUnion.addAll(ConstraintManager.addOperands("<", operand1, operand2));
                    return ImmutableList.copyOf(opUnion);
                }
                case LESS_THAN: {
                    return ConstraintManager.addOperands("<", operand1, operand2);
                }
                case LESS_EQUAL: {
                    return ConstraintManager.addOperands("=<", operand1, operand2);
                }
                case GREATER_THAN: {
                    return ConstraintManager.addOperands(">", operand1, operand2);
                }
                case GREATER_EQUAL: {
                    return ConstraintManager.addOperands(">=", operand1, operand2);
                }
            }
            return null;
        }
        return null;
    }

    private static Collection<Pair<Term, List<Term>>> paramExpressionToCLP(String paramName, AExpression ce) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        Variable paramVariable = ConstraintManager.CVar2PrologVar(paramName);
        vars.add(paramVariable);
        Term expTerm = null;
        if (ce instanceof CIdExpression) {
            vars.add(ConstraintManager.CVar2PrologVar(ce.toString()));
            expTerm = ConstraintManager.CVar2PrologVar(ce.toString());
            Compound paramAexpTerm = new Compound("=:=", new Term[]{paramVariable, expTerm});
            return ImmutableSet.of(Pair.of(Util.termArrayToList((Term[])new Term[]{paramAexpTerm}), vars));
        }
        if (ce instanceof CIntegerLiteralExpression) {
            expTerm = Util.textToTerm((String)("rdiv(" + ce + ",1)"));
            Compound paramAexpTerm = new Compound("=:=", new Term[]{paramVariable, expTerm});
            return ImmutableSet.of(Pair.of(Util.termArrayToList((Term[])new Term[]{paramAexpTerm}), vars));
        }
        if (ce instanceof CBinaryExpression) {
            CBinaryExpression bexp = (CBinaryExpression)ce;
            Collection<Pair<Term, List<Term>>> aexpTerms = ConstraintManager.expressionToCLP(ce);
            ImmutableList.Builder paramAexpTerms = ImmutableList.builderWithExpectedSize((int)aexpTerms.size());
            switch (bexp.getOperator()) {
                case PLUS: 
                case MINUS: 
                case MULTIPLY: 
                case DIVIDE: {
                    for (Pair<Term, List<Term>> aexpTerm : aexpTerms) {
                        ArrayList<Variable> aexpTermVars = new ArrayList<Variable>((Collection)aexpTerm.getSecond());
                        aexpTermVars.add(paramVariable);
                        Compound paramAexpTerm = new Compound("=:=", new Term[]{paramVariable, aexpTerm.getFirst()});
                        paramAexpTerms.add(Pair.of(Util.termArrayToList((Term[])new Term[]{paramAexpTerm}), aexpTermVars));
                    }
                    return paramAexpTerms.build();
                }
                case EQUALS: 
                case NOT_EQUALS: 
                case LESS_THAN: 
                case LESS_EQUAL: 
                case GREATER_THAN: 
                case GREATER_EQUAL: {
                    for (Pair<Term, List<Term>> aexpTerm : aexpTerms) {
                        ArrayList<Variable> aexpTermVars = new ArrayList<Variable>((Collection)aexpTerm.getSecond());
                        aexpTermVars.add(paramVariable);
                        Compound paramAexpTerm = new Compound("=:=", new Term[]{paramVariable, Util.textToTerm((String)"rdiv(1,1)")});
                        paramAexpTerms.add(Pair.of(Util.termArrayToList((Term[])new Term[]{paramAexpTerm, aexpTerm.getFirst()}), aexpTermVars));
                        paramAexpTerm = new Compound("=:=", new Term[]{paramVariable, Util.textToTerm((String)"rdiv(0,1)")});
                        for (Pair<Term, List<Term>> negAexpTerm : ConstraintManager.getNegatedConstraintList(aexpTerm)) {
                            paramAexpTerms.add(Pair.of(Util.termArrayToList((Term[])new Term[]{paramAexpTerm, negAexpTerm.getFirst()}), aexpTermVars));
                        }
                    }
                    return paramAexpTerms.build();
                }
            }
            return null;
        }
        return null;
    }

    private static Collection<Pair<Term, List<Term>>> addOperands(String operator, Collection<Pair<Term, List<Term>>> operand1, Collection<Pair<Term, List<Term>>> operand2) {
        ImmutableList.Builder termList = ImmutableList.builder();
        ArrayList vars = new ArrayList();
        for (Pair<Term, List<Term>> subop1 : operand1) {
            for (Pair<Term, List<Term>> subop2 : operand2) {
                vars.addAll(subop1.getSecond());
                vars.addAll(subop2.getSecond());
                termList.add(Pair.of(new Compound(operator, new Term[]{subop1.getFirst(), subop2.getFirst()}), vars));
            }
        }
        return termList.build();
    }

    private static boolean initFiringRelation(String firingRelation) {
        Object qStr = "assert((less(C1,C2)";
        switch (firingRelation) {
            case "Always": {
                break;
            }
            case "Maxcoeff": {
                qStr = (String)qStr + ":-less_maxcoeff_cns(C1,C2)";
                break;
            }
            case "Sumcoeff": {
                qStr = (String)qStr + ":-less_maxsum_cns(C1,C2)";
                break;
            }
            case "Homeocoeff": {
                qStr = (String)qStr + ":-homeo_embedded_cns(C1,C2)";
                break;
            }
            default: {
                throw new AssertionError((Object)"Not valid value for the firing relation");
            }
        }
        qStr = (String)qStr + "))";
        Query q = new Query((String)qStr);
        return q.hasSolution();
    }

    private static boolean initGeneralizationOperator(String generalizationOperator) {
        Object qStr = "assert((generalize(C1,C2,C3)";
        switch (generalizationOperator) {
            case "Top": {
                break;
            }
            case "Widen": {
                qStr = (String)qStr + ":-plain_cns_widening(C1,C2,C3)";
                break;
            }
            case "WidenMax": {
                qStr = (String)qStr + ":-e_leq_maxcoeff(C1,C2,C3)";
                break;
            }
            case "WidenSum": {
                qStr = (String)qStr + ":-e_leq_maxsum(C1,C2,C3)";
                break;
            }
            default: {
                throw new AssertionError((Object)"invalid value for the firing relation");
            }
        }
        qStr = (String)qStr + "))";
        Query q = new Query((String)qStr);
        return q.hasSolution();
    }

    public static Constraint convexHull(Constraint cn1, Constraint cn2s) {
        return new Constraint();
    }

    private ConstraintManager() {
    }
}

