/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.composite.CompositeDomain;
import org.sosy_lab.cpachecker.cpa.composite.CompositeMergeAgreeCPAEnabledAnalysisOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositeMergeAgreeOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositeMergePlainOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.composite.CompositeReducer;
import org.sosy_lab.cpachecker.cpa.composite.CompositeSimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.composite.CompositeStopOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositeTransferRelation;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

@Options(prefix="cpa.composite")
public final class CompositeCPA
implements StatisticsProvider,
WrapperCPA,
ConfigurableProgramAnalysisWithBAM,
ProofChecker {
    @Option(secure=true, toUppercase=true, values={"PLAIN", "AGREE"}, description="which composite merge operator to use (plain or agree)\nBoth delegate to the component cpas, but agree only allows merging if all cpas agree on this. This is probably what you want.")
    private String merge = "AGREE";
    @Option(secure=true, description="inform Composite CPA if it is run in a CPA enabled analysis because then it must behave differently during merge.")
    private boolean inCPAEnabledAnalysis = false;
    @Option(secure=true, description="By enabling this option the CompositeTransferRelation will compute abstract successors for as many edges as possible in one call. For any chain of edges in the CFA which does not have more than one outgoing or leaving edge the components of the CompositeCPA are called for each of the edges in this chain. Strengthening is still computed after every edge. The main difference is that while this option is enabled not every ARGState may have a single edge connecting to the child/parent ARGState but it may instead be a list.")
    private boolean aggregateBasicBlocks = false;
    private final ImmutableList<ConfigurableProgramAnalysis> cpas;
    private final CFA cfa;
    private final Supplier<MergeOperator> mergeSupplier;

    public static CPAFactory factory() {
        return new CompositeCPAFactory();
    }

    private CompositeCPA(Configuration config, CFA pCfa, ImmutableList<ConfigurableProgramAnalysis> cpas) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.cfa = pCfa;
        this.cpas = cpas;
        this.mergeSupplier = this.buildMergeOperatorSupplier();
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return new CompositeDomain((ImmutableList<AbstractDomain>)Collections3.transformedImmutableListCopy(this.cpas, ConfigurableProgramAnalysis::getAbstractDomain));
    }

    @Override
    public CompositeTransferRelation getTransferRelation() {
        return new CompositeTransferRelation((ImmutableList<TransferRelation>)Collections3.transformedImmutableListCopy(this.cpas, ConfigurableProgramAnalysis::getTransferRelation), this.cfa, this.aggregateBasicBlocks);
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeSupplier.get();
    }

    private Supplier<MergeOperator> buildMergeOperatorSupplier() throws InvalidConfigurationException {
        if (this.cpas.stream().map(ConfigurableProgramAnalysis::getMergeOperator).allMatch(mergeOp -> mergeOp == MergeSepOperator.getInstance())) {
            return () -> MergeSepOperator.getInstance();
        }
        switch (this.merge) {
            case "AGREE": {
                if (this.inCPAEnabledAnalysis) {
                    PredicateCPA predicateCPA = (PredicateCPA)Collections3.filterByClass((Stream)this.cpas.stream(), PredicateCPA.class).findFirst().orElseThrow(() -> new InvalidConfigurationException("Option 'cpa.composite.inCPAEnabledAnalysis' needs PredicateCPA"));
                    return () -> new CompositeMergeAgreeCPAEnabledAnalysisOperator(this.getMergeOperators(), this.getStopOperators(), predicateCPA.getPredicateManager());
                }
                return () -> new CompositeMergeAgreeOperator(this.getMergeOperators(), this.getStopOperators());
            }
            case "PLAIN": {
                if (this.inCPAEnabledAnalysis) {
                    throw new InvalidConfigurationException("Merge PLAIN is currently not supported for CompositeCPA in predicated analysis");
                }
                return () -> new CompositeMergePlainOperator(this.getMergeOperators());
            }
        }
        throw new AssertionError();
    }

    private ImmutableList<MergeOperator> getMergeOperators() {
        return Collections3.transformedImmutableListCopy(this.cpas, ConfigurableProgramAnalysis::getMergeOperator);
    }

    private ImmutableList<StopOperator> getStopOperators() {
        return Collections3.transformedImmutableListCopy(this.cpas, ConfigurableProgramAnalysis::getStopOperator);
    }

    @Override
    public CompositeStopOperator getStopOperator() {
        return new CompositeStopOperator(this.getStopOperators());
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        ImmutableList precisionAdjustments = Collections3.transformedImmutableListCopy(this.cpas, ConfigurableProgramAnalysis::getPrecisionAdjustment);
        if (precisionAdjustments.stream().allMatch(prec -> prec instanceof SimplePrecisionAdjustment)) {
            ImmutableList simplePrecisionAdjustments = precisionAdjustments;
            return new CompositeSimplePrecisionAdjustment((ImmutableList<SimplePrecisionAdjustment>)simplePrecisionAdjustments);
        }
        return new CompositePrecisionAdjustment((ImmutableList<PrecisionAdjustment>)precisionAdjustments);
    }

    @Override
    public Reducer getReducer() throws InvalidConfigurationException {
        ImmutableList.Builder wrappedReducers = ImmutableList.builder();
        for (ConfigurableProgramAnalysis cpa : this.cpas) {
            Preconditions.checkState((boolean)(cpa instanceof ConfigurableProgramAnalysisWithBAM), (String)"wrapped CPA does not support BAM: %s", (Object)cpa.getClass().getCanonicalName());
            wrappedReducers.add((Object)((ConfigurableProgramAnalysisWithBAM)cpa).getReducer());
        }
        return new CompositeReducer((List<Reducer>)wrappedReducers.build());
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        Preconditions.checkNotNull((Object)pNode);
        ImmutableList.Builder initialStates = ImmutableList.builder();
        for (ConfigurableProgramAnalysis sp : this.cpas) {
            initialStates.add((Object)sp.getInitialState(pNode, pPartition));
        }
        return new CompositeState((List<AbstractState>)initialStates.build());
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition partition) throws InterruptedException {
        Preconditions.checkNotNull((Object)pNode);
        ImmutableList.Builder initialPrecisions = ImmutableList.builder();
        for (ConfigurableProgramAnalysis sp : this.cpas) {
            initialPrecisions.add((Object)sp.getInitialPrecision(pNode, partition));
        }
        return new CompositePrecision((List<Precision>)initialPrecisions.build());
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        FluentIterable.from(this.cpas).filter(StatisticsProvider.class).forEach(cpa -> cpa.collectStatistics(pStatsCollection));
    }

    @Override
    public <T extends ConfigurableProgramAnalysis> T retrieveWrappedCpa(Class<T> pType) {
        if (pType.isAssignableFrom(this.getClass())) {
            return (T)((ConfigurableProgramAnalysis)pType.cast(this));
        }
        for (ConfigurableProgramAnalysis cpa : this.cpas) {
            T result;
            if (pType.isAssignableFrom(cpa.getClass())) {
                return (T)((ConfigurableProgramAnalysis)pType.cast(cpa));
            }
            if (!(cpa instanceof WrapperCPA) || (result = ((WrapperCPA)((Object)cpa)).retrieveWrappedCpa(pType)) == null) continue;
            return result;
        }
        return null;
    }

    public ImmutableList<ConfigurableProgramAnalysis> getWrappedCPAs() {
        return this.cpas;
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        return this.getTransferRelation().areAbstractSuccessors(pElement, pCfaEdge, pSuccessors, (List<ConfigurableProgramAnalysis>)this.cpas);
    }

    @Override
    public boolean isCoveredBy(AbstractState pElement, AbstractState pOtherElement) throws CPAException, InterruptedException {
        return this.getStopOperator().isCoveredBy(pElement, pOtherElement, (List<ConfigurableProgramAnalysis>)this.cpas);
    }

    @Override
    public void setPartitioning(BlockPartitioning partitioning) {
        this.cpas.forEach(cpa -> {
            Preconditions.checkState((boolean)(cpa instanceof ConfigurableProgramAnalysisWithBAM), (String)"wrapped CPA does not support BAM: %s", (Object)cpa.getClass().getCanonicalName());
            ((ConfigurableProgramAnalysisWithBAM)cpa).setPartitioning(partitioning);
        });
    }

    @Override
    public boolean isCoveredByRecursiveState(AbstractState pState1, AbstractState pState2) throws CPAException, InterruptedException {
        CompositeState state1 = (CompositeState)pState1;
        CompositeState state2 = (CompositeState)pState2;
        ImmutableList<AbstractState> states1 = state1.getWrappedStates();
        ImmutableList<AbstractState> states2 = state2.getWrappedStates();
        if (states1.size() != this.cpas.size()) {
            return false;
        }
        for (int idx = 0; idx < states1.size(); ++idx) {
            if (((ConfigurableProgramAnalysisWithBAM)this.cpas.get(idx)).isCoveredByRecursiveState((AbstractState)states1.get(idx), (AbstractState)states2.get(idx))) continue;
            return false;
        }
        return true;
    }

    private static class CompositeCPAFactory
    extends AbstractCPAFactory {
        private CFA cfa = null;
        private ImmutableList<ConfigurableProgramAnalysis> cpas = null;

        private CompositeCPAFactory() {
        }

        @Override
        public ConfigurableProgramAnalysis createInstance() throws InvalidConfigurationException {
            Preconditions.checkState((this.cpas != null ? 1 : 0) != 0, (Object)"CompositeCPA needs wrapped CPAs!");
            Preconditions.checkState((this.cfa != null ? 1 : 0) != 0, (Object)"CompositeCPA needs CFA information!");
            return new CompositeCPA(this.getConfiguration(), this.cfa, this.cpas);
        }

        @Override
        public CPAFactory setChild(ConfigurableProgramAnalysis pChild) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Use CompositeCPA to wrap several CPAs!");
        }

        @Override
        @CanIgnoreReturnValue
        public CPAFactory setChildren(List<ConfigurableProgramAnalysis> pChildren) {
            Preconditions.checkNotNull(pChildren);
            Preconditions.checkArgument((!pChildren.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((this.cpas == null ? 1 : 0) != 0);
            this.cpas = ImmutableList.copyOf(pChildren);
            return this;
        }

        @Override
        public <T> CPAFactory set(T pObject, Class<T> pClass) throws UnsupportedOperationException {
            if (pClass.equals(CFA.class)) {
                this.cfa = (CFA)pObject;
            }
            return super.set(pObject, pClass);
        }
    }
}

