/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

class CompositeDomain
implements AbstractDomain {
    private final ImmutableList<AbstractDomain> domains;

    CompositeDomain(ImmutableList<AbstractDomain> domains) {
        this.domains = domains;
    }

    @Override
    public AbstractState join(AbstractState pElement1, AbstractState pElement2) throws CPAException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLessOrEqual(AbstractState pElement1, AbstractState pElement2) throws CPAException, InterruptedException {
        CompositeState comp1 = (CompositeState)pElement1;
        CompositeState comp2 = (CompositeState)pElement2;
        ImmutableList<AbstractState> comp1Elements = comp1.getWrappedStates();
        ImmutableList<AbstractState> comp2Elements = comp2.getWrappedStates();
        Preconditions.checkState((comp1Elements.size() == comp2Elements.size() ? 1 : 0) != 0);
        Preconditions.checkState((comp1Elements.size() == this.domains.size() ? 1 : 0) != 0);
        for (int idx = 0; idx < comp1Elements.size(); ++idx) {
            AbstractDomain domain = (AbstractDomain)this.domains.get(idx);
            if (domain.isLessOrEqual((AbstractState)comp1Elements.get(idx), (AbstractState)comp2Elements.get(idx))) continue;
            return false;
        }
        return true;
    }
}

