/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.NonMergeableAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.java_smt.api.SolverException;

public class CompositeMergeAgreeCPAEnabledAnalysisOperator
implements MergeOperator {
    private final ImmutableList<MergeOperator> mergeOperators;
    private final ImmutableList<StopOperator> stopOperators;
    private final PredicateAbstractionManager abmgr;
    private Class<? extends AbstractState> enablerClass;
    private boolean isEnablerPredicate = false;

    CompositeMergeAgreeCPAEnabledAnalysisOperator(ImmutableList<MergeOperator> mergeOperators, ImmutableList<StopOperator> stopOperators, PredicateAbstractionManager pAbmgr) {
        this.mergeOperators = mergeOperators;
        this.stopOperators = stopOperators;
        this.abmgr = pAbmgr;
    }

    @Override
    public AbstractState merge(AbstractState successorState, AbstractState reachedState, Precision precision) throws CPAException, InterruptedException {
        CompositeState compSuccessorState = (CompositeState)successorState;
        CompositeState compReachedState = (CompositeState)reachedState;
        CompositePrecision compPrecision = (CompositePrecision)precision;
        boolean mergeIfPredicateEnabler = false;
        assert (compSuccessorState.getNumberOfStates() == compReachedState.getNumberOfStates());
        AbstractState enablerReached = null;
        if (this.enablerClass != null) {
            enablerReached = AbstractStates.extractStateByType(compReachedState, this.enablerClass);
        }
        if (this.isEnablerPredicate) {
            PredicateAbstractState predSuccessorState = AbstractStates.extractStateByType(successorState, PredicateAbstractState.class);
            PredicateAbstractState predReachedState = AbstractStates.extractStateByType(reachedState, PredicateAbstractState.class);
            if (predSuccessorState != null && predReachedState != null && predSuccessorState.isAbstractionState() && predReachedState.isAbstractionState()) {
                try {
                    if (predSuccessorState.getAbstractionFormula().asFormula() == predReachedState.getAbstractionFormula().asFormula() || this.abmgr.checkCoverage(predSuccessorState.getAbstractionFormula(), predReachedState.getAbstractionFormula()) && this.abmgr.checkCoverage(predReachedState.getAbstractionFormula(), predSuccessorState.getAbstractionFormula())) {
                        mergeIfPredicateEnabler = true;
                    }
                }
                catch (SolverException e) {
                    throw new CPAException("Solver Failure", e);
                }
            }
        }
        if (!mergeIfPredicateEnabler && (CompositeMergeAgreeCPAEnabledAnalysisOperator.hasNonMergeableState(compSuccessorState) || CompositeMergeAgreeCPAEnabledAnalysisOperator.hasNonMergeableState(compReachedState))) {
            return reachedState;
        }
        ImmutableList.Builder mergedStates = ImmutableList.builder();
        UnmodifiableIterator stopIter = this.stopOperators.iterator();
        UnmodifiableIterator comp1Iter = compSuccessorState.getWrappedStates().iterator();
        UnmodifiableIterator comp2Iter = compReachedState.getWrappedStates().iterator();
        UnmodifiableIterator precIter = compPrecision.getWrappedPrecisions().iterator();
        boolean identicalStates = true;
        for (MergeOperator mergeOp : this.mergeOperators) {
            AbstractState absSuccessorState = (AbstractState)comp1Iter.next();
            AbstractState absReachedState = (AbstractState)comp2Iter.next();
            if (mergeIfPredicateEnabler && absReachedState instanceof PredicateAbstractState) {
                mergedStates.add((Object)absReachedState);
                precIter.next();
                stopIter.next();
                continue;
            }
            Precision prec = (Precision)precIter.next();
            StopOperator stopOp = (StopOperator)stopIter.next();
            if (!this.isEnablerPredicate && absReachedState == enablerReached) {
                if (!(absSuccessorState.equals(absReachedState) || stopOp.stop(absSuccessorState, Collections.singleton(absReachedState), prec) && stopOp.stop(absReachedState, Collections.singleton(absSuccessorState), prec))) {
                    return reachedState;
                }
                mergedStates.add((Object)absReachedState);
                continue;
            }
            AbstractState mergedState = mergeOp.merge(absSuccessorState, absReachedState, prec);
            if (!stopOp.stop(absSuccessorState, Collections.singleton(mergedState), prec)) {
                return reachedState;
            }
            if (mergedState != absReachedState) {
                identicalStates = false;
            }
            mergedStates.add((Object)mergedState);
        }
        if (identicalStates) {
            return reachedState;
        }
        return new CompositeState((List<AbstractState>)mergedStates.build());
    }

    private static boolean hasNonMergeableState(CompositeState state) {
        return FluentIterable.from(state.getWrappedStates()).anyMatch(Predicates.instanceOf(NonMergeableAbstractState.class));
    }

    public void setEnablerStateClass(Class<? extends AbstractState> pStateClass) {
        this.isEnablerPredicate = pStateClass.equals(PredicateAbstractState.class);
        this.enablerClass = pStateClass;
    }
}

