/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.NonMergeableAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

class CompositeMergeAgreeOperator
implements MergeOperator {
    private final ImmutableList<MergeOperator> mergeOperators;
    private final ImmutableList<StopOperator> stopOperators;

    CompositeMergeAgreeOperator(ImmutableList<MergeOperator> mergeOperators, ImmutableList<StopOperator> stopOperators) {
        this.mergeOperators = mergeOperators;
        this.stopOperators = stopOperators;
    }

    @Override
    public AbstractState merge(AbstractState successorState, AbstractState reachedState, Precision precision) throws CPAException, InterruptedException {
        CompositeState compSuccessorState = (CompositeState)successorState;
        CompositeState compReachedState = (CompositeState)reachedState;
        CompositePrecision compPrecision = (CompositePrecision)precision;
        assert (compSuccessorState.getNumberOfStates() == compReachedState.getNumberOfStates());
        if (CompositeMergeAgreeOperator.hasNonMergeableState(compSuccessorState) || CompositeMergeAgreeOperator.hasNonMergeableState(compReachedState)) {
            return reachedState;
        }
        ImmutableList.Builder mergedStates = ImmutableList.builder();
        UnmodifiableIterator stopIter = this.stopOperators.iterator();
        UnmodifiableIterator comp1Iter = compSuccessorState.getWrappedStates().iterator();
        UnmodifiableIterator comp2Iter = compReachedState.getWrappedStates().iterator();
        UnmodifiableIterator precIter = compPrecision.getWrappedPrecisions().iterator();
        boolean identicalStates = true;
        for (MergeOperator mergeOp : this.mergeOperators) {
            AbstractState mergedState;
            AbstractState absSuccessorState = (AbstractState)comp1Iter.next();
            AbstractState absReachedState = (AbstractState)comp2Iter.next();
            Precision prec = (Precision)precIter.next();
            StopOperator stopOp = (StopOperator)stopIter.next();
            if (!stopOp.stop(absSuccessorState, Collections.singleton(mergedState = mergeOp.merge(absSuccessorState, absReachedState, prec)), prec)) {
                return reachedState;
            }
            if (mergedState != absReachedState) {
                identicalStates = false;
            }
            mergedStates.add((Object)mergedState);
        }
        if (identicalStates) {
            return reachedState;
        }
        return new CompositeState((List<AbstractState>)mergedStates.build());
    }

    private static boolean hasNonMergeableState(CompositeState state) {
        return FluentIterable.from(state.getWrappedStates()).anyMatch(Predicates.instanceOf(NonMergeableAbstractState.class));
    }
}

