/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

class CompositeMergePlainOperator
implements MergeOperator {
    private final ImmutableList<MergeOperator> mergeOperators;

    CompositeMergePlainOperator(ImmutableList<MergeOperator> mergeOperators) {
        this.mergeOperators = mergeOperators;
    }

    @Override
    public AbstractState merge(AbstractState successorState, AbstractState reachedState, Precision precision) throws CPAException, InterruptedException {
        CompositeState compSuccessorState = (CompositeState)successorState;
        CompositeState compReachedState = (CompositeState)reachedState;
        CompositePrecision compPrecision = (CompositePrecision)precision;
        assert (compSuccessorState.getNumberOfStates() == compReachedState.getNumberOfStates());
        ImmutableList.Builder mergedStates = ImmutableList.builder();
        UnmodifiableIterator iter1 = compSuccessorState.getWrappedStates().iterator();
        UnmodifiableIterator iter2 = compReachedState.getWrappedStates().iterator();
        UnmodifiableIterator iterPrec = compPrecision.getWrappedPrecisions().iterator();
        boolean identicalStates = true;
        for (MergeOperator mergeOp : this.mergeOperators) {
            AbstractState absReachedState;
            AbstractState absSuccessorState;
            AbstractState mergedState = mergeOp.merge(absSuccessorState = (AbstractState)iter1.next(), absReachedState = (AbstractState)iter2.next(), (Precision)iterPrec.next());
            if (mergedState != absReachedState) {
                identicalStates = false;
            }
            mergedStates.add((Object)mergedState);
        }
        if (identicalStates) {
            return reachedState;
        }
        return new CompositeState((List<AbstractState>)mergedStates.build());
    }
}

