/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiFunction;
import org.sosy_lab.cpachecker.core.interfaces.AdjustablePrecision;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.WrapperPrecision;

class CompositePrecision
implements WrapperPrecision,
AdjustablePrecision {
    private final ImmutableList<Precision> precisions;

    CompositePrecision(List<Precision> precisions) {
        this.precisions = ImmutableList.copyOf(precisions);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CompositePrecision)) {
            return false;
        }
        return this.precisions.equals(((CompositePrecision)other).precisions);
    }

    public int hashCode() {
        return this.precisions.hashCode();
    }

    Precision get(int idx) {
        return (Precision)this.precisions.get(idx);
    }

    public String toString() {
        return this.precisions.toString();
    }

    @Override
    public <T extends Precision> T retrieveWrappedPrecision(Class<T> pType) {
        if (pType.isAssignableFrom(this.getClass())) {
            return (T)((Precision)pType.cast(this));
        }
        for (Precision precision : this.precisions) {
            T result;
            if (pType.isAssignableFrom(precision.getClass())) {
                return (T)((Precision)pType.cast(precision));
            }
            if (!(precision instanceof WrapperPrecision) || (result = ((WrapperPrecision)precision).retrieveWrappedPrecision(pType)) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Precision replaceWrappedPrecision(Precision newPrecision, Predicate<? super Precision> replaceType) {
        if (replaceType.apply((Object)this)) {
            return newPrecision;
        }
        ImmutableList.Builder newPrecisions = ImmutableList.builder();
        boolean changed = false;
        for (Precision precision : this.precisions) {
            if (replaceType.apply((Object)precision)) {
                newPrecisions.add((Object)newPrecision);
                changed = true;
                continue;
            }
            if (precision instanceof WrapperPrecision) {
                Precision newWrappedPrecision = ((WrapperPrecision)precision).replaceWrappedPrecision(newPrecision, replaceType);
                if (newWrappedPrecision != null) {
                    newPrecisions.add((Object)newWrappedPrecision);
                    changed = true;
                    continue;
                }
                newPrecisions.add((Object)precision);
                continue;
            }
            newPrecisions.add((Object)precision);
        }
        return changed ? new CompositePrecision((List<Precision>)newPrecisions.build()) : null;
    }

    public ImmutableList<Precision> getWrappedPrecisions() {
        return this.precisions;
    }

    @Override
    public AdjustablePrecision add(AdjustablePrecision pOtherPrecision) {
        return this.adjustPrecisionWith(pOtherPrecision, (a, b) -> a.add((AdjustablePrecision)b));
    }

    @Override
    public AdjustablePrecision subtract(AdjustablePrecision pOtherPrecision) {
        return this.adjustPrecisionWith(pOtherPrecision, (a, b) -> a.subtract((AdjustablePrecision)b));
    }

    private AdjustablePrecision adjustPrecisionWith(AdjustablePrecision pOtherPrecision, BiFunction<AdjustablePrecision, AdjustablePrecision, AdjustablePrecision> adjustFunction) {
        ImmutableList.Builder newPrecisions = ImmutableList.builder();
        for (int i = 0; i < this.precisions.size(); ++i) {
            Precision adjustedPrecision;
            Precision currentPrecision = this.get(i);
            if (pOtherPrecision instanceof CompositePrecision) {
                CompositePrecision precisionToAdjust = (CompositePrecision)pOtherPrecision;
                adjustedPrecision = precisionToAdjust.get(i);
            } else if (pOtherPrecision.getClass() == currentPrecision.getClass()) {
                adjustedPrecision = pOtherPrecision;
            } else {
                newPrecisions.add((Object)currentPrecision);
                continue;
            }
            Preconditions.checkArgument((boolean)(currentPrecision instanceof AdjustablePrecision), (String)"Precision %s does not support adjusting precision", (Object)currentPrecision);
            Preconditions.checkArgument((boolean)(adjustedPrecision instanceof AdjustablePrecision), (String)"Precision %s does not support adjusting precision", (Object)adjustedPrecision);
            Precision newPrecision = adjustFunction.apply((AdjustablePrecision)currentPrecision, (AdjustablePrecision)adjustedPrecision);
            newPrecisions.add((Object)newPrecision);
        }
        return new CompositePrecision((List<Precision>)newPrecisions.build());
    }

    @Override
    public boolean isEmpty() {
        return FluentIterable.from(this.precisions).transform(p -> (AdjustablePrecision)p).allMatch(AdjustablePrecision::isEmpty);
    }
}

