/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

class CompositePrecisionAdjustment
implements PrecisionAdjustment {
    private final ImmutableList<PrecisionAdjustment> precisionAdjustments;
    private final ImmutableList<Function<AbstractState, AbstractState>> stateProjectionFunctions;

    CompositePrecisionAdjustment(ImmutableList<PrecisionAdjustment> precisionAdjustments) {
        this.precisionAdjustments = precisionAdjustments;
        ImmutableList.Builder stateProjections = ImmutableList.builder();
        for (int i = 0; i < precisionAdjustments.size(); ++i) {
            stateProjections.add(this.getStateProjectionFunction(i));
        }
        this.stateProjectionFunctions = stateProjections.build();
    }

    private Function<AbstractState, AbstractState> getStateProjectionFunction(int i) {
        return compState -> ((CompositeState)compState).get(i);
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pElement, Precision pPrecision, UnmodifiableReachedSet pElements, Function<AbstractState, AbstractState> projection, AbstractState fullState) throws CPAException, InterruptedException {
        CompositePrecision outPrecision;
        CompositeState comp = (CompositeState)pElement;
        CompositePrecision prec = (CompositePrecision)pPrecision;
        assert (comp.getWrappedStates().size() == prec.getWrappedPrecisions().size());
        int dim = comp.getWrappedStates().size();
        ImmutableList.Builder outElements = ImmutableList.builder();
        ImmutableList.Builder outPrecisions = ImmutableList.builder();
        boolean modified = false;
        PrecisionAdjustmentResult.Action action = PrecisionAdjustmentResult.Action.CONTINUE;
        for (int i = 0; i < dim; ++i) {
            Precision oldPrecision;
            AbstractState oldElement;
            PrecisionAdjustment precisionAdjustment = (PrecisionAdjustment)this.precisionAdjustments.get(i);
            Optional<PrecisionAdjustmentResult> out = precisionAdjustment.prec(oldElement = comp.get(i), oldPrecision = prec.get(i), pElements, (Function<AbstractState, AbstractState>)Functions.compose((Function)((Function)this.stateProjectionFunctions.get(i)), projection), fullState);
            if (!out.isPresent()) {
                return Optional.empty();
            }
            PrecisionAdjustmentResult inner = out.orElseThrow();
            AbstractState newElement = inner.abstractState();
            Precision newPrecision = inner.precision();
            if (inner.action() == PrecisionAdjustmentResult.Action.BREAK) {
                action = PrecisionAdjustmentResult.Action.BREAK;
            }
            if (newElement != oldElement || newPrecision != oldPrecision) {
                modified = true;
            }
            outElements.add((Object)newElement);
            outPrecisions.add((Object)newPrecision);
        }
        CompositeState outElement = modified ? new CompositeState((List<AbstractState>)outElements.build()) : comp;
        Optional<CompositeState> outElementStrengthened = this.callStrengthen(outElement, outPrecision = modified ? new CompositePrecision((List<Precision>)outPrecisions.build()) : prec);
        if (!outElementStrengthened.isPresent()) {
            return Optional.empty();
        }
        outElement = outElementStrengthened.orElseThrow();
        PrecisionAdjustmentResult out = PrecisionAdjustmentResult.create(outElement, outPrecision, action);
        return Optional.of(out);
    }

    private Optional<CompositeState> callStrengthen(CompositeState pCompositeState, CompositePrecision pCompositePrecision) throws CPAException, InterruptedException {
        ImmutableList<AbstractState> wrappedStates = pCompositeState.getWrappedStates();
        ImmutableList<Precision> wrappedPrecisions = pCompositePrecision.getWrappedPrecisions();
        int dim = wrappedStates.size();
        ImmutableList.Builder newElements = ImmutableList.builder();
        boolean modified = false;
        for (int i = 0; i < dim; ++i) {
            Iterable otherStates;
            Precision oldPrecision;
            AbstractState oldElement;
            PrecisionAdjustment precisionAdjustment = (PrecisionAdjustment)this.precisionAdjustments.get(i);
            Optional<? extends AbstractState> out = precisionAdjustment.strengthen(oldElement = (AbstractState)wrappedStates.get(i), oldPrecision = (Precision)wrappedPrecisions.get(i), otherStates = Iterables.concat((Iterable)wrappedStates.subList(0, i), (Iterable)wrappedStates.subList(i + 1, dim)));
            if (!out.isPresent()) {
                return Optional.empty();
            }
            AbstractState unwrapped = out.get();
            if (unwrapped != oldElement) {
                modified = true;
            }
            newElements.add((Object)unwrapped);
        }
        CompositeState outState = modified ? new CompositeState((List<AbstractState>)newElements.build()) : pCompositeState;
        return Optional.of(outState);
    }
}

