/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.defaults.GenericReducer;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;

class CompositeReducer
extends GenericReducer<CompositeState, CompositePrecision> {
    private final List<Reducer> wrappedReducers;

    CompositeReducer(List<Reducer> pWrappedReducers) {
        this.wrappedReducers = pWrappedReducers;
    }

    @Override
    protected CompositeState getVariableReducedState0(CompositeState pExpandedState, Block pContext, CFANode pLocation) throws InterruptedException {
        ImmutableList<AbstractState> states = pExpandedState.getWrappedStates();
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)this.wrappedReducers.size());
        for (int i = 0; i < this.wrappedReducers.size(); ++i) {
            result.add((Object)this.wrappedReducers.get(i).getVariableReducedState((AbstractState)states.get(i), pContext, pLocation));
        }
        return new CompositeState((List<AbstractState>)result.build());
    }

    @Override
    protected CompositeState getVariableExpandedState0(CompositeState pRootState, Block pReducedContext, CompositeState pReducedState) throws InterruptedException {
        ImmutableList<AbstractState> rootStates = pRootState.getWrappedStates();
        ImmutableList<AbstractState> reducedStates = pReducedState.getWrappedStates();
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)this.wrappedReducers.size());
        for (int i = 0; i < this.wrappedReducers.size(); ++i) {
            AbstractState nestedState = this.wrappedReducers.get(i).getVariableExpandedState((AbstractState)rootStates.get(i), pReducedContext, (AbstractState)reducedStates.get(i));
            if (nestedState == null) {
                return null;
            }
            result.add((Object)nestedState);
        }
        return new CompositeState((List<AbstractState>)result.build());
    }

    @Override
    protected Object getHashCodeForState0(CompositeState pElementKey, CompositePrecision pPrecisionKey) {
        ImmutableList<AbstractState> elements = pElementKey.getWrappedStates();
        ImmutableList<Precision> precisions = pPrecisionKey.getWrappedPrecisions();
        ArrayList<Object> result = new ArrayList<Object>(this.wrappedReducers.size());
        for (int i = 0; i < this.wrappedReducers.size(); ++i) {
            result.add(this.wrappedReducers.get(i).getHashCodeForState((AbstractState)elements.get(i), (Precision)precisions.get(i)));
        }
        return result;
    }

    @Override
    protected Precision getVariableReducedPrecision0(CompositePrecision pPrecision, Block pContext) {
        ImmutableList<Precision> precisions = pPrecision.getWrappedPrecisions();
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)this.wrappedReducers.size());
        for (int i = 0; i < this.wrappedReducers.size(); ++i) {
            result.add((Object)this.wrappedReducers.get(i).getVariableReducedPrecision((Precision)precisions.get(i), pContext));
        }
        return new CompositePrecision((List<Precision>)result.build());
    }

    @Override
    protected CompositePrecision getVariableExpandedPrecision0(CompositePrecision pRootPrecision, Block pRootContext, CompositePrecision pReducedPrecision) {
        ImmutableList<Precision> rootPrecisions = pRootPrecision.getWrappedPrecisions();
        ImmutableList<Precision> reducedPrecisions = pReducedPrecision.getWrappedPrecisions();
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)this.wrappedReducers.size());
        for (int i = 0; i < this.wrappedReducers.size(); ++i) {
            result.add((Object)this.wrappedReducers.get(i).getVariableExpandedPrecision((Precision)rootPrecisions.get(i), pRootContext, (Precision)reducedPrecisions.get(i)));
        }
        return new CompositePrecision((List<Precision>)result.build());
    }

    @Override
    protected int measurePrecisionDifference0(CompositePrecision pPrecision, CompositePrecision pOtherPrecision) {
        ImmutableList<Precision> precisions = pPrecision.getWrappedPrecisions();
        ImmutableList<Precision> otherPrecisions = pOtherPrecision.getWrappedPrecisions();
        int sum = 0;
        for (int i = 0; i < this.wrappedReducers.size(); ++i) {
            sum += this.wrappedReducers.get(i).measurePrecisionDifference((Precision)precisions.get(i), (Precision)otherPrecisions.get(i));
        }
        return sum;
    }

    @Override
    protected CompositeState getVariableReducedStateForProofChecking0(CompositeState pExpandedState, Block pContext, CFANode pCallNode) throws InterruptedException {
        ImmutableList<AbstractState> expandedStates = pExpandedState.getWrappedStates();
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)this.wrappedReducers.size());
        for (int i = 0; i < this.wrappedReducers.size(); ++i) {
            result.add((Object)this.wrappedReducers.get(i).getVariableReducedStateForProofChecking((AbstractState)expandedStates.get(i), pContext, pCallNode));
        }
        return new CompositeState((List<AbstractState>)result.build());
    }

    @Override
    protected CompositeState getVariableExpandedStateForProofChecking0(CompositeState pRootState, Block pReducedContext, CompositeState pReducedState) throws InterruptedException {
        ImmutableList<AbstractState> rootStates = pRootState.getWrappedStates();
        ImmutableList<AbstractState> reducedStates = pReducedState.getWrappedStates();
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)this.wrappedReducers.size());
        for (int i = 0; i < this.wrappedReducers.size(); ++i) {
            AbstractState nestedState = this.wrappedReducers.get(i).getVariableExpandedStateForProofChecking((AbstractState)rootStates.get(i), pReducedContext, (AbstractState)reducedStates.get(i));
            if (nestedState == null) {
                return null;
            }
            result.add((Object)nestedState);
        }
        return new CompositeState((List<AbstractState>)result.build());
    }

    @Override
    protected CompositeState rebuildStateAfterFunctionCall0(CompositeState pRootState, CompositeState pEntryState, CompositeState pExpandedState, FunctionExitNode exitLocation) {
        ImmutableList<AbstractState> rootStates = pRootState.getWrappedStates();
        ImmutableList<AbstractState> entryStates = pEntryState.getWrappedStates();
        ImmutableList<AbstractState> expandedStates = pExpandedState.getWrappedStates();
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)this.wrappedReducers.size());
        for (int i = 0; i < this.wrappedReducers.size(); ++i) {
            result.add((Object)this.wrappedReducers.get(i).rebuildStateAfterFunctionCall((AbstractState)rootStates.get(i), (AbstractState)entryStates.get(i), (AbstractState)expandedStates.get(i), exitLocation));
        }
        return new CompositeState((List<AbstractState>)result.build());
    }

    @Override
    protected boolean canBeUsedInCache0(CompositeState pState) {
        for (int i = 0; i < this.wrappedReducers.size(); ++i) {
            if (this.wrappedReducers.get(i).canBeUsedInCache(pState.get(i))) continue;
            return false;
        }
        return true;
    }
}

