/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.collect.ImmutableList;
import org.sosy_lab.cpachecker.core.defaults.SimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

class CompositeSimplePrecisionAdjustment
extends SimplePrecisionAdjustment {
    private final ImmutableList<SimplePrecisionAdjustment> precisionAdjustments;

    CompositeSimplePrecisionAdjustment(ImmutableList<SimplePrecisionAdjustment> precisionAdjustments) {
        this.precisionAdjustments = precisionAdjustments;
    }

    @Override
    public PrecisionAdjustmentResult.Action prec(AbstractState pElement, Precision pPrecision) throws CPAException {
        CompositeState comp = (CompositeState)pElement;
        CompositePrecision prec = (CompositePrecision)pPrecision;
        assert (comp.getWrappedStates().size() == prec.getWrappedPrecisions().size());
        int dim = comp.getNumberOfStates();
        for (int i = 0; i < dim; ++i) {
            Precision oldPrecision;
            AbstractState oldElement;
            SimplePrecisionAdjustment precisionAdjustment = (SimplePrecisionAdjustment)this.precisionAdjustments.get(i);
            PrecisionAdjustmentResult.Action action = precisionAdjustment.prec(oldElement = comp.get(i), oldPrecision = prec.get(i));
            if (action != PrecisionAdjustmentResult.Action.BREAK) continue;
            return PrecisionAdjustmentResult.Action.BREAK;
        }
        return PrecisionAdjustmentResult.Action.CONTINUE;
    }
}

