/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.interfaces.PseudoPartitionable;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.arg.Splitable;

public class CompositeState
implements AbstractWrapperState,
Targetable,
Partitionable,
PseudoPartitionable,
Serializable,
Graphable,
Splitable {
    private static final long serialVersionUID = -5143296331663510680L;
    private final ImmutableList<AbstractState> states;
    private transient Object partitionKey;
    private transient Comparable<?> pseudoPartitionKey;
    private transient Object pseudoHashCode;

    public CompositeState(List<AbstractState> elements) {
        this.states = ImmutableList.copyOf(elements);
    }

    int getNumberOfStates() {
        return this.states.size();
    }

    @Override
    public boolean isTarget() {
        for (AbstractState element : this.states) {
            if (!(element instanceof Targetable) || !((Targetable)((Object)element)).isTarget()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Targetable.TargetInformation> getTargetInformation() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isTarget());
        ImmutableSet.Builder properties = ImmutableSet.builder();
        for (AbstractState element : this.states) {
            if (!(element instanceof Targetable) || !((Targetable)((Object)element)).isTarget()) continue;
            properties.addAll(((Targetable)((Object)element)).getTargetInformation());
        }
        return properties.build();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (AbstractState element : this.states) {
            builder.append(element.getClass().getSimpleName());
            builder.append(": ");
            builder.append(element.toString());
            builder.append("\n ");
        }
        builder.replace(builder.length() - 1, builder.length(), ")");
        return builder.toString();
    }

    @Override
    public String toDOTLabel() {
        StringBuilder builder = new StringBuilder();
        for (AbstractState element : this.states) {
            String label;
            if (!(element instanceof Graphable) || (label = ((Graphable)((Object)element)).toDOTLabel()).isEmpty()) continue;
            builder.append(element.getClass().getSimpleName());
            builder.append(": ");
            builder.append(label);
            builder.append("\\n ");
        }
        return builder.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        for (AbstractState element : this.states) {
            if (!(element instanceof Graphable) || !((Graphable)((Object)element)).shouldBeHighlighted()) continue;
            return true;
        }
        return false;
    }

    public AbstractState get(int idx) {
        return (AbstractState)this.states.get(idx);
    }

    public ImmutableList<AbstractState> getWrappedStates() {
        return this.states;
    }

    @Override
    public Object getPartitionKey() {
        if (this.partitionKey == null) {
            Object[] keys = new Object[this.states.size()];
            int i = 0;
            for (AbstractState element : this.states) {
                if (element instanceof Partitionable) {
                    keys[i] = ((Partitionable)((Object)element)).getPartitionKey();
                }
                ++i;
            }
            this.partitionKey = new CompositePartitionKey(keys);
        }
        return this.partitionKey;
    }

    @Override
    public Comparable<?> getPseudoPartitionKey() {
        if (this.pseudoPartitionKey == null) {
            Comparable[] keys = new Comparable[this.states.size()];
            int i = 0;
            for (AbstractState element : this.states) {
                if (element instanceof PseudoPartitionable) {
                    keys[i] = ((PseudoPartitionable)((Object)element)).getPseudoPartitionKey();
                }
                ++i;
            }
            this.pseudoPartitionKey = new CompositePseudoPartitionKey(keys);
        }
        return this.pseudoPartitionKey;
    }

    @Override
    public Object getPseudoHashCode() {
        if (this.pseudoHashCode == null) {
            Object[] keys = new Object[this.states.size()];
            int i = 0;
            for (AbstractState element : this.states) {
                if (element instanceof PseudoPartitionable) {
                    keys[i] = ((PseudoPartitionable)((Object)element)).getPseudoHashCode();
                }
                ++i;
            }
            this.pseudoHashCode = new CompositePartitionKey(keys);
        }
        return this.pseudoHashCode;
    }

    @Override
    public AbstractState forkWithReplacements(Collection<AbstractState> pReplacementStates) {
        ImmutableList<AbstractState> wrappedStates = this.getWrappedStates();
        ArrayList<AbstractState> newWrappedStates = new ArrayList<AbstractState>(wrappedStates.size());
        for (AbstractState state : wrappedStates) {
            int targetSize = newWrappedStates.size() + 1;
            if (targetSize <= newWrappedStates.size()) continue;
            if (state instanceof Splitable) {
                newWrappedStates.add(((Splitable)((Object)state)).forkWithReplacements(pReplacementStates));
                continue;
            }
            newWrappedStates.add(state);
        }
        CompositeState newState = new CompositeState(newWrappedStates);
        return newState;
    }

    private static final class CompositePseudoPartitionKey
    implements Comparable<CompositePseudoPartitionKey> {
        private final Comparable<?>[] keys;

        private CompositePseudoPartitionKey(Comparable<?>[] pElements) {
            this.keys = pElements;
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (!(pObj instanceof CompositePseudoPartitionKey)) {
                return false;
            }
            return Arrays.equals(this.keys, ((CompositePseudoPartitionKey)pObj).keys);
        }

        public int hashCode() {
            return Arrays.hashCode(this.keys);
        }

        public String toString() {
            return "[" + Joiner.on((String)", ").skipNulls().join((Object[])this.keys) + "]";
        }

        @Override
        public int compareTo(CompositePseudoPartitionKey other) {
            Preconditions.checkArgument((this.keys.length == other.keys.length ? 1 : 0) != 0);
            ComparisonChain c = ComparisonChain.start();
            for (int i = 0; i < this.keys.length; ++i) {
                c = c.compare(this.keys[i], other.keys[i], (Comparator)Ordering.natural().nullsFirst());
            }
            return c.result();
        }
    }

    private static final class CompositePartitionKey {
        private final Object[] keys;

        private CompositePartitionKey(Object[] pElements) {
            this.keys = pElements;
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (!(pObj instanceof CompositePartitionKey)) {
                return false;
            }
            return Arrays.equals(this.keys, ((CompositePartitionKey)pObj).keys);
        }

        public int hashCode() {
            return Arrays.hashCode(this.keys);
        }

        public String toString() {
            return "[" + Joiner.on((String)", ").skipNulls().join(this.keys) + "]";
        }
    }
}

