/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.composite;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocations;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.WrapperTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.cpa.composite.CompositePrecision;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;

final class CompositeTransferRelation
implements WrapperTransferRelation {
    private final ImmutableList<TransferRelation> transferRelations;
    private final CFA cfa;
    private final int size;
    private final boolean predicatesPresent;
    private final boolean aggregateBasicBlocks;

    CompositeTransferRelation(ImmutableList<TransferRelation> pTransferRelations, CFA pCFA, boolean pAggregateBasicBlocks) {
        this.transferRelations = pTransferRelations;
        this.cfa = pCFA;
        this.size = pTransferRelations.size();
        this.aggregateBasicBlocks = pAggregateBasicBlocks;
        this.predicatesPresent = Iterables.indexOf(pTransferRelations, (Predicate)Predicates.instanceOf(PredicateTransferRelation.class)) != -1;
    }

    public Collection<CompositeState> getAbstractSuccessors(AbstractState element, Precision precision) throws CPATransferException, InterruptedException {
        CompositeState compositeState = (CompositeState)element;
        CompositePrecision compositePrecision = (CompositePrecision)precision;
        AbstractStateWithLocations locState = AbstractStates.extractStateByType(compositeState, AbstractStateWithLocations.class);
        ArrayList<CompositeState> results = new ArrayList<CompositeState>(2);
        if (locState == null) {
            this.getAbstractSuccessors(compositeState, compositePrecision, results);
        } else {
            for (CFAEdge edge : locState.getOutgoingEdges()) {
                this.getAbstractSuccessorForEdge(compositeState, compositePrecision, edge, results);
            }
        }
        return results;
    }

    private void getAbstractSuccessors(CompositeState pCompositeState, CompositePrecision pCompositePrecision, Collection<CompositeState> compositeSuccessors) throws CPATransferException, InterruptedException {
        Precision lCurrentPrecision;
        AbstractState lCurrentElement;
        TransferRelation lCurrentTransfer;
        Collection<? extends AbstractState> componentSuccessors;
        int resultCount = 1;
        ImmutableList<AbstractState> componentElements = pCompositeState.getWrappedStates();
        Preconditions.checkArgument((componentElements.size() == this.size ? 1 : 0) != 0, (Object)"State with wrong number of component states given");
        ArrayList<Collection<? extends AbstractState>> allComponentsSuccessors = new ArrayList<Collection<? extends AbstractState>>(this.size);
        for (int i = 0; i < this.size && (resultCount *= (componentSuccessors = (lCurrentTransfer = (TransferRelation)this.transferRelations.get(i)).getAbstractSuccessors(lCurrentElement = (AbstractState)componentElements.get(i), lCurrentPrecision = pCompositePrecision.get(i))).size()) != 0; ++i) {
            allComponentsSuccessors.add(componentSuccessors);
        }
        for (List<AbstractState> successor : CompositeTransferRelation.createCartesianProduct(allComponentsSuccessors, resultCount)) {
            compositeSuccessors.add(new CompositeState(successor));
        }
    }

    public Collection<CompositeState> getAbstractSuccessorsForEdge(AbstractState element, Precision precision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        CompositeState compositeState = (CompositeState)element;
        CompositePrecision compositePrecision = (CompositePrecision)precision;
        ArrayList<CompositeState> results = new ArrayList<CompositeState>(1);
        this.getAbstractSuccessorForSimpleEdge(compositeState, compositePrecision, cfaEdge, results);
        return results;
    }

    private void getAbstractSuccessorForEdge(CompositeState compositeState, CompositePrecision compositePrecision, CFAEdge cfaEdge, Collection<CompositeState> compositeSuccessors) throws CPATransferException, InterruptedException {
        if (this.aggregateBasicBlocks) {
            CFANode startNode = cfaEdge.getPredecessor();
            if (this.isValidMultiEdgeStart(startNode) && this.isValidMultiEdgeComponent(cfaEdge)) {
                Collection<CompositeState> currentStates = new ArrayList<CompositeState>(1);
                currentStates.add(compositeState);
                while (this.isValidMultiEdgeComponent(cfaEdge)) {
                    ArrayList<CompositeState> successorStates = new ArrayList<CompositeState>(currentStates.size());
                    for (CompositeState currentState : currentStates) {
                        this.getAbstractSuccessorForSimpleEdge(currentState, compositePrecision, cfaEdge, successorStates);
                    }
                    if (FluentIterable.from(successorStates).anyMatch(AbstractStates::isTargetState)) {
                        compositeSuccessors.addAll(successorStates);
                        return;
                    }
                    currentStates = Collections.unmodifiableCollection(successorStates);
                    if (cfaEdge.getSuccessor().getNumLeavingEdges() != 1) break;
                    cfaEdge = cfaEdge.getSuccessor().getLeavingEdge(0);
                }
                compositeSuccessors.addAll(currentStates);
            } else {
                this.getAbstractSuccessorForSimpleEdge(compositeState, compositePrecision, cfaEdge, compositeSuccessors);
            }
        } else {
            this.getAbstractSuccessorForSimpleEdge(compositeState, compositePrecision, cfaEdge, compositeSuccessors);
        }
    }

    private boolean isValidMultiEdgeStart(CFANode node) {
        return node.getNumLeavingEdges() == 1 && node.getLeavingSummaryEdge() == null && node.getNumEnteringEdges() > 0;
    }

    private boolean isValidMultiEdgeComponent(CFAEdge edge) {
        boolean result = edge.getEdgeType() == CFAEdgeType.BlankEdge || edge.getEdgeType() == CFAEdgeType.DeclarationEdge || edge.getEdgeType() == CFAEdgeType.StatementEdge || edge.getEdgeType() == CFAEdgeType.ReturnStatementEdge;
        CFANode nodeAfterEdge = edge.getSuccessor();
        result = result && nodeAfterEdge.getNumEnteringEdges() == 1 && nodeAfterEdge.getClass() == CFANode.class;
        return result && !this.containsFunctionCall(edge);
    }

    private boolean containsFunctionCall(CFAEdge edge) {
        if (edge.getEdgeType() == CFAEdgeType.StatementEdge) {
            CStatementEdge statementEdge = (CStatementEdge)edge;
            if (statementEdge.getStatement() instanceof CFunctionCall) {
                CFunctionCall call = (CFunctionCall)statementEdge.getStatement();
                CFunctionDeclaration declaration = call.getFunctionCallExpression().getDeclaration();
                return declaration == null || this.cfa.getAllFunctionNames().contains(declaration.getQualifiedName());
            }
            return statementEdge.getStatement() instanceof CFunctionCall;
        }
        return false;
    }

    private void getAbstractSuccessorForSimpleEdge(CompositeState compositeState, CompositePrecision compositePrecision, CFAEdge cfaEdge, Collection<CompositeState> compositeSuccessors) throws CPATransferException, InterruptedException {
        assert (cfaEdge != null);
        Collection<List<AbstractState>> allResultingElements = this.callTransferRelation(compositeState, compositePrecision, cfaEdge);
        for (List<AbstractState> lReachedState : allResultingElements) {
            Collection<List<AbstractState>> lResultingElements = this.callStrengthen(lReachedState, compositePrecision, cfaEdge);
            for (List<AbstractState> lList : lResultingElements) {
                compositeSuccessors.add(new CompositeState(lList));
            }
        }
    }

    private Collection<List<AbstractState>> callTransferRelation(CompositeState compositeState, CompositePrecision compositePrecision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        Precision lCurrentPrecision;
        AbstractState lCurrentElement;
        TransferRelation lCurrentTransfer;
        Collection<? extends AbstractState> componentSuccessors;
        int resultCount = 1;
        ImmutableList<AbstractState> componentElements = compositeState.getWrappedStates();
        Preconditions.checkArgument((componentElements.size() == this.size ? 1 : 0) != 0, (Object)"State with wrong number of component states given");
        ArrayList<Collection<? extends AbstractState>> allComponentsSuccessors = new ArrayList<Collection<? extends AbstractState>>(this.size);
        for (int i = 0; i < this.size && (resultCount *= (componentSuccessors = (lCurrentTransfer = (TransferRelation)this.transferRelations.get(i)).getAbstractSuccessorsForEdge(lCurrentElement = (AbstractState)componentElements.get(i), lCurrentPrecision = compositePrecision.get(i), cfaEdge)).size()) != 0; ++i) {
            allComponentsSuccessors.add(componentSuccessors);
        }
        return CompositeTransferRelation.createCartesianProduct(allComponentsSuccessors, resultCount);
    }

    private Collection<List<AbstractState>> callStrengthen(List<AbstractState> reachedState, CompositePrecision compositePrecision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        Precision lCurrentPrecision;
        AbstractState lCurrentElement;
        TransferRelation lCurrentTransfer;
        Collection<? extends AbstractState> lResultsList;
        ArrayList<Collection<? extends AbstractState>> lStrengthenResults = new ArrayList<Collection<? extends AbstractState>>(this.size);
        int resultCount = 1;
        for (int i = 0; i < this.size && (resultCount *= (lResultsList = (lCurrentTransfer = (TransferRelation)this.transferRelations.get(i)).strengthen(lCurrentElement = reachedState.get(i), reachedState, cfaEdge, lCurrentPrecision = compositePrecision.get(i))).size()) != 0; ++i) {
            lStrengthenResults.add(lResultsList);
        }
        Collection<List<AbstractState>> strengthenedStates = CompositeTransferRelation.createCartesianProduct(lStrengthenResults, resultCount);
        if (this.predicatesPresent && resultCount > 0) {
            Iterator<List<AbstractState>> it = strengthenedStates.iterator();
            while (it.hasNext()) {
                List<AbstractState> strengthenedState = it.next();
                ImmutableList assumptionElements = FluentIterable.from(strengthenedState).filter(CompositeTransferRelation::hasAssumptions).toList();
                if (assumptionElements.isEmpty()) continue;
                int predIndex = Iterables.indexOf(strengthenedState, x -> x instanceof PredicateAbstractState);
                Preconditions.checkState((predIndex >= 0 ? 1 : 0) != 0, (Object)"cartesian product should ensure that predicates do not vanish!");
                AbstractState predElement = strengthenedState.get(predIndex);
                Precision predPrecision = compositePrecision.get(predIndex);
                TransferRelation predTransfer = (TransferRelation)this.transferRelations.get(predIndex);
                Collection<? extends AbstractState> predResult = predTransfer.strengthen(predElement, (Iterable<AbstractState>)assumptionElements, cfaEdge, predPrecision);
                if (predResult.isEmpty()) {
                    it.remove();
                    --resultCount;
                    continue;
                }
                assert (predResult.size() == 1);
                strengthenedState.set(predIndex, predResult.iterator().next());
            }
        }
        if (!Iterables.any(reachedState, AbstractStates::isTargetState)) {
            ArrayList<List<AbstractState>> newStrengthenedStates = new ArrayList<List<AbstractState>>(resultCount);
            for (List<AbstractState> strengthenedState : strengthenedStates) {
                if (Iterables.any(strengthenedState, AbstractStates::isTargetState)) {
                    newStrengthenedStates.addAll(this.callStrengthen(strengthenedState, compositePrecision, cfaEdge));
                    continue;
                }
                newStrengthenedStates.add(strengthenedState);
            }
            return newStrengthenedStates;
        }
        return strengthenedStates;
    }

    private static boolean hasAssumptions(AbstractState x) {
        return x instanceof AbstractStateWithAssumptions || x instanceof AssumptionStorageState || x instanceof FormulaReportingState;
    }

    static Collection<List<AbstractState>> createCartesianProduct(List<Collection<? extends AbstractState>> allComponentsSuccessors, int resultCount) {
        Object allResultingElements;
        switch (resultCount) {
            case 0: {
                allResultingElements = ImmutableSet.of();
                break;
            }
            case 1: {
                ArrayList<AbstractState> resultingElements = new ArrayList<AbstractState>(allComponentsSuccessors.size());
                for (Collection<? extends AbstractState> componentSuccessors : allComponentsSuccessors) {
                    resultingElements.add((AbstractState)Iterables.getOnlyElement(componentSuccessors));
                }
                allResultingElements = Collections.singleton(resultingElements);
                break;
            }
            default: {
                ImmutableList initialPrefix = ImmutableList.of();
                allResultingElements = new ArrayList(resultCount);
                CompositeTransferRelation.createCartesianProduct0(allComponentsSuccessors, (List<AbstractState>)initialPrefix, (Collection<List<AbstractState>>)allResultingElements);
            }
        }
        assert (resultCount == allResultingElements.size());
        return allResultingElements;
    }

    private static void createCartesianProduct0(List<Collection<? extends AbstractState>> allComponentsSuccessors, List<AbstractState> prefix, Collection<List<AbstractState>> allResultingElements) {
        if (prefix.size() == allComponentsSuccessors.size()) {
            allResultingElements.add(prefix);
        } else {
            int depth = prefix.size();
            Collection<? extends AbstractState> myComponentsSuccessors = allComponentsSuccessors.get(depth);
            for (AbstractState abstractState : myComponentsSuccessors) {
                ArrayList<AbstractState> newPrefix = new ArrayList<AbstractState>(prefix);
                newPrefix.add(abstractState);
                CompositeTransferRelation.createCartesianProduct0(allComponentsSuccessors, newPrefix, allResultingElements);
            }
        }
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState element, Iterable<AbstractState> otherElements, CFAEdge cfaEdge, Precision precision) throws CPATransferException, InterruptedException {
        Precision lCurrentPrecision;
        AbstractState lCurrentElement;
        TransferRelation lCurrentTransfer;
        Collection<? extends AbstractState> lResultsList;
        CompositeState compositeState = (CompositeState)element;
        CompositePrecision compositePrecision = (CompositePrecision)precision;
        ArrayList<Collection<? extends AbstractState>> lStrengthenResults = new ArrayList<Collection<? extends AbstractState>>(this.size);
        int resultCount = 1;
        for (int i = 0; i < this.size && (resultCount *= (lResultsList = (lCurrentTransfer = (TransferRelation)this.transferRelations.get(i)).strengthen(lCurrentElement = compositeState.get(i), otherElements, cfaEdge, lCurrentPrecision = compositePrecision.get(i))).size()) != 0; ++i) {
            lStrengthenResults.add(lResultsList);
        }
        Collection<List<AbstractState>> lResultingElements = CompositeTransferRelation.createCartesianProduct(lStrengthenResults, resultCount);
        return Collections3.transformedImmutableListCopy(lResultingElements, CompositeState::new);
    }

    boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors, List<ConfigurableProgramAnalysis> cpas) throws CPATransferException, InterruptedException {
        Preconditions.checkNotNull((Object)pCfaEdge);
        Preconditions.checkState((!this.aggregateBasicBlocks ? 1 : 0) != 0);
        CompositeState compositeState = (CompositeState)pElement;
        int resultCount = 1;
        boolean result = true;
        for (int i = 0; i < this.size; ++i) {
            HashSet<AbstractState> componentSuccessors = new HashSet<AbstractState>();
            for (AbstractState abstractState : pSuccessors) {
                CompositeState compositeSuccessor = (CompositeState)abstractState;
                if (compositeSuccessor.getNumberOfStates() != this.size) {
                    return false;
                }
                componentSuccessors.add(compositeSuccessor.get(i));
            }
            resultCount *= componentSuccessors.size();
            ProofChecker proofChecker = (ProofChecker)((Object)cpas.get(i));
            if (!proofChecker.areAbstractSuccessors(compositeState.get(i), pCfaEdge, componentSuccessors)) {
                result = false;
                continue;
            }
            if (!componentSuccessors.isEmpty()) continue;
            assert (pSuccessors.isEmpty());
            return true;
        }
        if (resultCount > pSuccessors.size()) {
            return false;
        }
        HashSet<ImmutableList<AbstractState>> states = new HashSet<ImmutableList<AbstractState>>();
        for (AbstractState abstractState : pSuccessors) {
            states.add(((CompositeState)abstractState).getWrappedStates());
        }
        if (resultCount != states.size()) {
            return false;
        }
        return result;
    }

    @Override
    public <T extends TransferRelation> @Nullable T retrieveWrappedTransferRelation(Class<T> pType) {
        if (pType.isAssignableFrom(this.getClass())) {
            return (T)((TransferRelation)pType.cast(this));
        }
        for (TransferRelation tr : this.transferRelations) {
            T result;
            if (pType.isAssignableFrom(tr.getClass())) {
                return (T)((TransferRelation)pType.cast(tr));
            }
            if (!(tr instanceof WrapperTransferRelation) || (result = ((WrapperTransferRelation)tr).retrieveWrappedTransferRelation(pType)) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Iterable<TransferRelation> getWrappedTransferRelations() {
        return this.transferRelations;
    }
}

