/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.conditions.global;

import com.google.common.base.Function;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.conditions.global.GlobalConditionsSimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.conditions.global.GlobalConditionsThresholds;
import org.sosy_lab.cpachecker.exceptions.CPAException;

class GlobalConditionsPrecisionAdjustment
implements PrecisionAdjustment {
    private final LogManager logger;
    private final GlobalConditionsThresholds thresholds;
    private final GlobalConditionsSimplePrecisionAdjustment delegate;

    GlobalConditionsPrecisionAdjustment(LogManager pLogger, GlobalConditionsThresholds pThresholds, GlobalConditionsSimplePrecisionAdjustment pDelegate) {
        this.logger = pLogger;
        this.thresholds = pThresholds;
        this.delegate = pDelegate;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pElement, Precision pPrecision, UnmodifiableReachedSet pElements, Function<AbstractState, AbstractState> projection, AbstractState fullState) throws CPAException {
        if (this.checkReachedSetSize(pElements)) {
            this.logger.log(Level.WARNING, new Object[]{"Reached set size threshold reached, terminating."});
            return Optional.of(PrecisionAdjustmentResult.create(pElement, pPrecision, PrecisionAdjustmentResult.Action.BREAK));
        }
        return Optional.of(PrecisionAdjustmentResult.create(pElement, pPrecision, this.delegate.prec(pElement, pPrecision)));
    }

    private boolean checkReachedSetSize(UnmodifiableReachedSet elements) {
        long threshold = this.thresholds.getReachedSetSizeThreshold();
        if (threshold >= 0L) {
            return (long)elements.size() > threshold;
        }
        return false;
    }
}

