/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.conditions.global;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeErrorException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.defaults.SimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.cpa.conditions.global.GlobalConditionsThresholds;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.resources.ManagementUtils;
import org.sosy_lab.cpachecker.util.resources.ProcessCpuTime;

class GlobalConditionsSimplePrecisionAdjustment
extends SimplePrecisionAdjustment {
    private final LogManager logger;
    private final GlobalConditionsThresholds thresholds;
    private final MBeanServer mbeanServer;
    private final ObjectName osMbean;
    private static final String MEMORY_SIZE = "CommittedVirtualMemorySize";
    private final MemoryMXBean memory;
    private boolean cpuTimeDisabled = false;
    private boolean processMemoryDisabled = false;

    GlobalConditionsSimplePrecisionAdjustment(LogManager pLogger, GlobalConditionsThresholds pThresholds) {
        this.logger = pLogger;
        this.thresholds = pThresholds;
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.memory = ManagementFactory.getMemoryMXBean();
        try {
            this.osMbean = new ObjectName("java.lang:type=OperatingSystem");
        }
        catch (MalformedObjectNameException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public PrecisionAdjustmentResult.Action prec(AbstractState pElement, Precision pPrecision) throws CPAException {
        if (this.checkWallTime()) {
            this.logger.log(Level.WARNING, new Object[]{"Wall time threshold reached, terminating."});
            return PrecisionAdjustmentResult.Action.BREAK;
        }
        if (this.checkCpuTime()) {
            this.logger.log(Level.WARNING, new Object[]{"Cpu time threshold reached, terminating."});
            return PrecisionAdjustmentResult.Action.BREAK;
        }
        if (this.checkHeapMemory()) {
            this.logger.log(Level.WARNING, new Object[]{"Java heap memory threshold reached, terminating."});
            return PrecisionAdjustmentResult.Action.BREAK;
        }
        if (this.checkProcessMemory()) {
            this.logger.log(Level.WARNING, new Object[]{"Process memory threshold reached, terminating."});
            return PrecisionAdjustmentResult.Action.BREAK;
        }
        return PrecisionAdjustmentResult.Action.CONTINUE;
    }

    private boolean checkWallTime() {
        return System.currentTimeMillis() > this.thresholds.getWallTimeThreshold();
    }

    private boolean checkCpuTime() {
        long cputimeNanos;
        if (this.cpuTimeDisabled) {
            return false;
        }
        long threshold = this.thresholds.getCpuTimeThreshold();
        if (threshold < 0L) {
            return false;
        }
        try {
            cputimeNanos = ProcessCpuTime.read();
        }
        catch (JMException e) {
            this.logger.logDebugException((Throwable)e, "Querying cpu time failed");
            this.logger.log(Level.WARNING, new Object[]{"Your Java VM does not support measuring the cpu time, cpu time threshold disabled"});
            this.cpuTimeDisabled = true;
            return false;
        }
        long cputime = cputimeNanos / 1000000L;
        return cputime > threshold;
    }

    private boolean checkHeapMemory() {
        long threshold = this.thresholds.getHeapMemoryThreshold();
        if (threshold < 0L) {
            return false;
        }
        return this.memory.getHeapMemoryUsage().getUsed() / 1000000L > threshold;
    }

    private boolean checkProcessMemory() {
        Object memUsedObject;
        if (this.processMemoryDisabled) {
            return false;
        }
        long threshold = this.thresholds.getProcessMemoryThreshold();
        if (threshold < 0L) {
            return false;
        }
        try {
            memUsedObject = this.mbeanServer.getAttribute(this.osMbean, MEMORY_SIZE);
        }
        catch (RuntimeErrorException e) {
            throw ManagementUtils.handleRuntimeErrorException(e);
        }
        catch (JMException e) {
            this.logger.logDebugException((Throwable)e, "Querying memory size failed");
            this.logger.log(Level.WARNING, new Object[]{"Your Java VM does not support measuring the memory size, process memory threshold disabled"});
            this.processMemoryDisabled = true;
            return false;
        }
        if (!(memUsedObject instanceof Long)) {
            this.logger.log(Level.WARNING, new Object[]{"Invalid value received for memory size: " + memUsedObject + ", process memory threshold disabled"});
            this.processMemoryDisabled = true;
            return false;
        }
        long memUsed = (Long)memUsedObject / 1000000L;
        return memUsed > threshold;
    }
}

