/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.conditions.global;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.log.LogManager;

@Options(prefix="cpa.conditions.global")
class GlobalConditionsThresholds {
    @Option(secure=true, name="reached.size", description="Limit for size of reached set (-1 for infinite)")
    @IntegerOption(min=-1L)
    private int reachedSetSize = -1;
    @Option(secure=true, name="time.wall", description="Limit for wall time used by CPAchecker (use milliseconds or specify a unit; -1 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.MILLISECONDS, defaultUserUnit=TimeUnit.MILLISECONDS, min=-1L)
    private long wallTime = -1L;
    private long wallEndTime;
    @Option(secure=true, name="time.wall.hardlimit", description="Hard limit for wall time used by CPAchecker (use milliseconds or specify a unit; -1 for infinite)\nWhen using adjustable conditions, analysis will end after this threshold")
    @TimeSpanOption(codeUnit=TimeUnit.MILLISECONDS, defaultUserUnit=TimeUnit.MILLISECONDS, min=-1L)
    private long wallTimeHardLimit = -1L;
    private long wallEndTimeHardLimit;
    @Option(secure=true, name="time.cpu", description="Limit for cpu time used by CPAchecker (use milliseconds or specify a unit; -1 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.MILLISECONDS, defaultUserUnit=TimeUnit.MILLISECONDS, min=-1L)
    private long cpuTime = -1L;
    private long cpuEndTime;
    @Option(secure=true, name="time.cpu.hardlimit", description="Hard limit for cpu time used by CPAchecker (use milliseconds or specify a unit; -1 for infinite)\nWhen using adjustable conditions, analysis will end after this threshold")
    @TimeSpanOption(codeUnit=TimeUnit.MILLISECONDS, defaultUserUnit=TimeUnit.MILLISECONDS, min=-1L)
    private long cpuTimeHardLimit = -1L;
    @Option(secure=true, name="memory.heap", description="Limit for Java heap memory used by CPAchecker (in MB, not MiB!; -1 for infinite)")
    @IntegerOption(min=-1L)
    private long heapMemory = -1L;
    @Option(secure=true, name="memory.process", description="Limit for process memory used by CPAchecker (in MB, not MiB!; -1 for infinite)")
    @IntegerOption(min=-1L)
    private long processMemory = -1L;
    private final LogManager logger;
    private String humanReadableString;

    GlobalConditionsThresholds(Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.wallEndTime = this.wallTime >= 0L ? System.currentTimeMillis() + this.wallTime : Long.MAX_VALUE;
        this.wallEndTimeHardLimit = this.wallTimeHardLimit >= 0L ? System.currentTimeMillis() + this.wallTimeHardLimit : Long.MAX_VALUE;
        this.wallEndTime = Math.min(this.wallEndTime, this.wallEndTimeHardLimit);
        this.cpuEndTime = this.cpuTime;
        this.humanReadableString = this.asHumanReadableString();
    }

    boolean adjustPrecision() {
        if (System.currentTimeMillis() >= this.wallEndTimeHardLimit) {
            return false;
        }
        if (this.cpuEndTime >= 0L && this.cpuEndTime >= this.cpuTimeHardLimit) {
            return false;
        }
        boolean changed = false;
        if (this.wallTime >= 0L) {
            this.wallEndTime = System.currentTimeMillis() + this.wallTime;
            this.wallEndTime = Math.min(this.wallEndTime, this.wallEndTimeHardLimit);
            changed = true;
        }
        if (this.cpuTime >= 0L) {
            this.cpuEndTime += this.cpuTime;
            this.cpuEndTime = Math.min(this.cpuEndTime, this.cpuTimeHardLimit);
            changed = true;
        }
        if (changed) {
            this.humanReadableString = this.asHumanReadableString();
            this.logger.log(Level.INFO, new Object[]{"Increased global condition thresholds."});
        }
        return true;
    }

    public boolean isLimitEnabled() {
        return this.reachedSetSize >= 0 || this.wallTime >= 0L || this.cpuTime >= 0L || this.heapMemory >= 0L || this.processMemory >= 0L;
    }

    private String asHumanReadableString() {
        if (!this.isLimitEnabled()) {
            return "global conditions: none";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("global conditions: ");
        if (this.reachedSetSize >= 0) {
            sb.append("reached set size: ");
            sb.append(this.reachedSetSize);
            sb.append("; ");
        }
        if (this.wallTime >= 0L) {
            sb.append("timeout (walltime): ");
            sb.append(this.wallTime / 1000L);
            sb.append(" s");
            if (this.wallTimeHardLimit >= 0L) {
                sb.append(" (up to ");
                sb.append(this.wallTimeHardLimit / 1000L);
                sb.append(" s)");
            }
            sb.append("; ");
        }
        if (this.cpuTime >= 0L) {
            sb.append("timeout (cputime): ");
            sb.append(this.cpuTime / 1000L);
            sb.append(" s; ");
            if (this.cpuTimeHardLimit >= 0L) {
                sb.append(" (up to ");
                sb.append(this.cpuTimeHardLimit / 1000L);
                sb.append(" s)");
            }
        }
        if (this.heapMemory >= 0L) {
            sb.append("heap usage limit: ");
            sb.append(this.heapMemory);
            sb.append(" MiB; ");
        }
        if (this.processMemory >= 0L) {
            sb.append("process memory limit: ");
            sb.append(this.processMemory);
            sb.append(" MiB; ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    int getReachedSetSizeThreshold() {
        return this.reachedSetSize;
    }

    long getWallTimeThreshold() {
        return this.wallEndTime;
    }

    long getCpuTimeThreshold() {
        return this.cpuEndTime;
    }

    public long getHeapMemoryThreshold() {
        return this.heapMemory;
    }

    public long getProcessMemoryThreshold() {
        return this.processMemory;
    }

    public String toString() {
        return this.humanReadableString;
    }
}

