/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.conditions.path;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingState;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.conditions.path.PathCondition;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.java_smt.api.BooleanFormula;

@Options(prefix="cpa.conditions.path.assignments")
public class AssignmentsInPathCondition
implements PathCondition,
Statistics {
    private static final int DISABLED = -1;
    @Option(secure=true, description="sets the threshold for assignments (-1 for infinite), and it is upto, e.g., ValueAnalysisPrecisionAdjustment to act accordingly to this threshold value.")
    @IntegerOption(min=-1L)
    private int threshold = -1;
    @Option(secure=true, description="determines if there should be one single assignment state per state, one per path segment between assume edges, or a global one for the whole program.")
    private Scope scope = Scope.STATE;
    private int maxNumberOfAssignments = 0;

    public AssignmentsInPathCondition(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
    }

    @Override
    public AvoidanceReportingState getInitialState(CFANode node) {
        return new UniqueAssignmentsInPathConditionState();
    }

    @Override
    public AvoidanceReportingState getAbstractSuccessor(AbstractState pElement, CFAEdge pEdge) {
        UniqueAssignmentsInPathConditionState current = (UniqueAssignmentsInPathConditionState)pElement;
        this.maxNumberOfAssignments = Math.max(this.maxNumberOfAssignments, current.getMaximum());
        if (this.scope == Scope.STATE || this.scope == Scope.PATH && pEdge.getEdgeType() == CFAEdgeType.AssumeEdge) {
            return new UniqueAssignmentsInPathConditionState(current.maximum, (Multimap<MemoryLocation, Value>)HashMultimap.create(current.mapping));
        }
        return current;
    }

    @Override
    public boolean adjustPrecision() {
        this.threshold *= 2;
        return true;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reachedSet) {
        out.println("Max. number of assignments: " + this.maxNumberOfAssignments);
    }

    @Override
    public Reducer getReducer() {
        return new AssignementsInPathConditionReducer();
    }

    private static enum Scope {
        STATE,
        PATH,
        PROGRAM;

    }

    private class AssignementsInPathConditionReducer
    implements Reducer {
        private AssignementsInPathConditionReducer() {
        }

        @Override
        public AbstractState getVariableReducedState(AbstractState pExpandedState, Block pContext, CFANode pCallNode) {
            return AssignmentsInPathCondition.this.getInitialState(pCallNode);
        }

        @Override
        public AbstractState getVariableExpandedState(AbstractState pRootState, Block pReducedContext, AbstractState pReducedState) {
            return pRootState;
        }

        @Override
        public Precision getVariableReducedPrecision(Precision pPrecision, Block pContext) {
            return pPrecision;
        }

        @Override
        public Precision getVariableExpandedPrecision(Precision pRootPrecision, Block pRootContext, Precision pReducedPrecision) {
            return pRootPrecision;
        }

        @Override
        public Object getHashCodeForState(AbstractState pStateKey, Precision pPrecisionKey) {
            return ((UniqueAssignmentsInPathConditionState)pStateKey).mapping;
        }

        @Override
        public AbstractState rebuildStateAfterFunctionCall(AbstractState pRootState, AbstractState pEntryState, AbstractState pExpandedState, FunctionExitNode pExitLocation) {
            return pRootState;
        }
    }

    public class UniqueAssignmentsInPathConditionState
    implements AbstractState,
    AvoidanceReportingState {
        private Multimap<MemoryLocation, Value> mapping = HashMultimap.create();
        private int maximum;

        private UniqueAssignmentsInPathConditionState() {
            this(0, (Multimap<MemoryLocation, Value>)HashMultimap.create());
        }

        private UniqueAssignmentsInPathConditionState(int pMaximum, Multimap<MemoryLocation, Value> pMapping) {
            this.maximum = pMaximum;
            this.mapping = pMapping;
        }

        private int getMaximum() {
            return this.maximum;
        }

        @Override
        public BooleanFormula getReasonFormula(FormulaManagerView formulaManager) {
            return PreventingHeuristic.ASSIGNMENTSINPATH.getFormula(formulaManager, this.maximum);
        }

        @Override
        public boolean mustDumpAssumptionForAvoidance() {
            return AssignmentsInPathCondition.this.threshold != -1 && this.maximum > AssignmentsInPathCondition.this.threshold;
        }

        public boolean exceedsThreshold(MemoryLocation memoryLocation) {
            return AssignmentsInPathCondition.this.threshold != -1 && this.mapping.get((Object)memoryLocation).size() > AssignmentsInPathCondition.this.threshold;
        }

        public void updateAssignmentInformation(MemoryLocation memoryLocation, Value value) {
            this.mapping.put((Object)memoryLocation, (Object)value);
            this.maximum = Math.max(this.maximum, this.mapping.get((Object)memoryLocation).size());
        }

        @Override
        public String toString() {
            return this.mapping + " [max: " + this.maximum + "]";
        }

        public Set<MemoryLocation> getMemoryLocationsExceedingThreshold() {
            HashSet<MemoryLocation> exceedingMemoryLocations = new HashSet<MemoryLocation>();
            for (MemoryLocation memoryLocation : this.mapping.keys()) {
                if (this.mapping.get((Object)memoryLocation).size() <= AssignmentsInPathCondition.this.threshold) continue;
                exceedingMemoryLocations.add(memoryLocation);
            }
            return exceedingMemoryLocations;
        }
    }
}

