/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.conditions.path;

import java.io.PrintStream;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.NoOpReducer;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingState;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.conditions.path.AssumeEdgesInPathConditionState;
import org.sosy_lab.cpachecker.cpa.conditions.path.PathCondition;

@Options(prefix="cpa.conditions.path.assumeedges")
public class AssumeEdgesInPathCondition
implements PathCondition,
Statistics {
    @Option(secure=true, description="maximum number of assume edges length (-1 for infinite)", name="limit")
    @IntegerOption(min=-1L)
    private int threshold = -1;
    private int increaseThresholdBy = 0;
    private int maxAssumeEdgesInPath = 0;

    public AssumeEdgesInPathCondition(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
    }

    @Override
    public AvoidanceReportingState getInitialState(CFANode pNode) {
        return new AssumeEdgesInPathConditionState(0, false);
    }

    @Override
    public AvoidanceReportingState getAbstractSuccessor(AbstractState pState, CFAEdge pEdge) {
        AssumeEdgesInPathConditionState current = (AssumeEdgesInPathConditionState)pState;
        if (pEdge.getEdgeType() != CFAEdgeType.AssumeEdge) {
            return current;
        }
        if (current.isThresholdReached()) {
            return current;
        }
        int assumeEdgesInPath = current.getPathLength() + 1;
        boolean thresholdReached = this.threshold >= 0 && assumeEdgesInPath >= this.threshold;
        this.maxAssumeEdgesInPath = Math.max(assumeEdgesInPath, this.maxAssumeEdgesInPath);
        return new AssumeEdgesInPathConditionState(assumeEdgesInPath, thresholdReached);
    }

    @Override
    public boolean adjustPrecision() {
        if (this.threshold == -1) {
            this.threshold = this.maxAssumeEdgesInPath / 5;
            this.increaseThresholdBy = this.threshold / 4;
        } else {
            this.threshold += this.increaseThresholdBy;
        }
        return true;
    }

    @Override
    public String getName() {
        return "Assume edges in path condition";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        out.println("Maximum length of a path: " + this.maxAssumeEdgesInPath);
        out.println("Threshold value:          " + this.threshold);
    }

    @Override
    public Reducer getReducer() {
        return NoOpReducer.getInstance();
    }
}

