/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.conditions.path;

import java.util.Objects;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingState;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public final class AssumeEdgesInPathConditionState
implements AbstractState,
AvoidanceReportingState {
    private final int assumeEdgesInPath;
    private final boolean thresholdReached;

    AssumeEdgesInPathConditionState(int pPathLength, boolean pThresholdReached) {
        this.assumeEdgesInPath = pPathLength;
        this.thresholdReached = pThresholdReached;
    }

    @Override
    public boolean mustDumpAssumptionForAvoidance() {
        return this.thresholdReached;
    }

    @Override
    public BooleanFormula getReasonFormula(FormulaManagerView pMgr) {
        return PreventingHeuristic.ASSUMEEDGESINPATH.getFormula(pMgr, this.assumeEdgesInPath);
    }

    public int getPathLength() {
        return this.assumeEdgesInPath;
    }

    boolean isThresholdReached() {
        return this.thresholdReached;
    }

    @Override
    public String toString() {
        return "path length: " + this.assumeEdgesInPath + (this.thresholdReached ? " (threshold reached)" : "");
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        AssumeEdgesInPathConditionState that = (AssumeEdgesInPathConditionState)pO;
        return this.assumeEdgesInPath == that.assumeEdgesInPath && this.thresholdReached == that.thresholdReached;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.assumeEdgesInPath, this.thresholdReached);
    }
}

