/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.conditions.path;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.io.PrintStream;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.NoOpReducer;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AvoidanceReportingState;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.conditions.path.PathCondition;
import org.sosy_lab.cpachecker.util.assumptions.PreventingHeuristic;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

@Options(prefix="cpa.conditions.path.repetitions")
public class RepetitionsInPathCondition
implements PathCondition,
Statistics {
    @Option(secure=true, description="maximum repetitions of any edge in a path (-1 for infinite)", name="limit")
    @IntegerOption(min=-1L)
    private int threshold = -1;
    private int increaseThresholdBy = 0;
    private int maxRepetitionsInPath = 0;

    public RepetitionsInPathCondition(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
    }

    @Override
    public AvoidanceReportingState getInitialState(CFANode pNode) {
        return new RepetitionsInPathConditionState((Multiset<CFAEdge>)ImmutableMultiset.of(), this.threshold, false);
    }

    private boolean isInteresting(CFAEdge edge) {
        return edge.getEdgeType() == CFAEdgeType.FunctionCallEdge || edge.getPredecessor().isLoopStart();
    }

    @Override
    public AvoidanceReportingState getAbstractSuccessor(AbstractState pState, CFAEdge pEdge) {
        RepetitionsInPathConditionState current = (RepetitionsInPathConditionState)pState;
        if (!this.isInteresting(pEdge)) {
            return current;
        }
        if (current.thresholdReached) {
            return current;
        }
        int repetitions = current.frequencyMap.count((Object)pEdge);
        boolean thresholdReached = this.threshold >= 0 && ++repetitions >= this.threshold;
        this.maxRepetitionsInPath = Math.max(repetitions, this.maxRepetitionsInPath);
        ImmutableMultiset newFrequencyMap = ImmutableMultiset.builder().addAll(current.frequencyMap).setCount((Object)pEdge, repetitions).build();
        return new RepetitionsInPathConditionState((Multiset<CFAEdge>)newFrequencyMap, this.threshold, thresholdReached);
    }

    @Override
    public boolean adjustPrecision() {
        if (this.threshold == -1) {
            this.increaseThresholdBy = this.threshold = this.maxRepetitionsInPath / 5;
        } else {
            this.threshold += this.increaseThresholdBy;
        }
        return true;
    }

    @Override
    public String getName() {
        return "Repetitions in path condition";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        out.println("Maximum repetitions in a path: " + this.maxRepetitionsInPath);
        out.println("Threshold value:               " + this.threshold);
    }

    @Override
    public Reducer getReducer() {
        return NoOpReducer.getInstance();
    }

    private static class RepetitionsInPathConditionState
    implements AbstractState,
    AvoidanceReportingState {
        private final ImmutableMultiset<CFAEdge> frequencyMap;
        private final int threshold;
        private final boolean thresholdReached;

        private RepetitionsInPathConditionState(Multiset<CFAEdge> pFrequencyMap, int pThreshold, boolean pThresholdReached) {
            this.frequencyMap = ImmutableMultiset.copyOf(pFrequencyMap);
            this.threshold = pThreshold;
            this.thresholdReached = pThresholdReached;
        }

        @Override
        public boolean mustDumpAssumptionForAvoidance() {
            return this.thresholdReached;
        }

        @Override
        public BooleanFormula getReasonFormula(FormulaManagerView pMgr) {
            return PreventingHeuristic.REPETITIONSINPATH.getFormula(pMgr, this.threshold);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Multiset.Entry entry : this.frequencyMap.entrySet()) {
                builder.append(entry.getCount()).append("x(").append(entry.getElement()).append(") ");
            }
            return builder.toString();
        }
    }
}

