/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.congruence;

import java.util.Collection;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.abe.ABECPA;
import org.sosy_lab.cpachecker.cpa.congruence.CongruenceManager;
import org.sosy_lab.cpachecker.cpa.congruence.CongruenceState;
import org.sosy_lab.cpachecker.cpa.congruence.CongruenceStatistics;
import org.sosy_lab.cpachecker.util.predicates.pathformula.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.templates.TemplatePrecision;
import org.sosy_lab.cpachecker.util.templates.TemplateToFormulaConversionManager;

@Options(prefix="cpa.congruence")
public class CongruenceCPA
implements ConfigurableProgramAnalysis,
StatisticsProvider,
AutoCloseable {
    @Option(secure=true, description="Cache formulas produced by path formula manager")
    private boolean useCachingPathFormulaManager = true;
    private final CongruenceStatistics statistics;
    private final ABECPA<CongruenceState, TemplatePrecision> abeCPA;
    private final Solver solver;

    public CongruenceCPA(Configuration pConfiguration, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCFA) throws InvalidConfigurationException {
        pConfiguration.inject((Object)this);
        this.solver = Solver.create(pConfiguration, pLogger, pShutdownNotifier);
        FormulaManagerView formulaManager = this.solver.getFormulaManager();
        PathFormulaManager pathFormulaManager = new PathFormulaManagerImpl(formulaManager, pConfiguration, pLogger, pShutdownNotifier, pCFA, AnalysisDirection.FORWARD);
        if (this.useCachingPathFormulaManager) {
            pathFormulaManager = new CachingPathFormulaManager(pathFormulaManager);
        }
        TemplateToFormulaConversionManager templateToFormulaConversionManager = new TemplateToFormulaConversionManager(pCFA, pLogger);
        this.statistics = new CongruenceStatistics();
        CongruenceManager congruenceManager = new CongruenceManager(pConfiguration, this.solver, templateToFormulaConversionManager, formulaManager, this.statistics, pathFormulaManager, pLogger, pCFA, pShutdownNotifier);
        this.abeCPA = new ABECPA<CongruenceState, TemplatePrecision>(pConfiguration, pLogger, pShutdownNotifier, pCFA, congruenceManager, this.solver);
    }

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(CongruenceCPA.class);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abeCPA.getAbstractDomain();
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.abeCPA.getTransferRelation();
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.abeCPA.getMergeOperator();
    }

    @Override
    public StopOperator getStopOperator() {
        return this.abeCPA.getStopOperator();
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.abeCPA.getPrecisionAdjustment();
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition partition) throws InterruptedException {
        return this.abeCPA.getInitialState(node, partition);
    }

    @Override
    public Precision getInitialPrecision(CFANode node, StateSpacePartition partition) throws InterruptedException {
        return this.abeCPA.getInitialPrecision(node, partition);
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this.statistics);
    }

    @Override
    public void close() {
        this.solver.close();
    }
}

