/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.congruence;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.abe.ABEAbstractedState;
import org.sosy_lab.cpachecker.cpa.abe.ABEIntermediateState;
import org.sosy_lab.cpachecker.cpa.abe.ABEManager;
import org.sosy_lab.cpachecker.cpa.congruence.Congruence;
import org.sosy_lab.cpachecker.cpa.congruence.CongruenceState;
import org.sosy_lab.cpachecker.cpa.congruence.CongruenceStatistics;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.templates.Template;
import org.sosy_lab.cpachecker.util.templates.TemplatePrecision;
import org.sosy_lab.cpachecker.util.templates.TemplateToFormulaConversionManager;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.congruence")
public class CongruenceManager
implements ABEManager<CongruenceState, TemplatePrecision> {
    @Option(secure=true, description="Generate congruences for sums of variables (<=> x and y have same/different evenness)")
    private boolean trackCongruenceSum = false;
    private final Solver solver;
    private final TemplateToFormulaConversionManager templateToFormulaConversionManager;
    private final BitvectorFormulaManager bvfmgr;
    private final FormulaManagerView fmgr;
    private final CongruenceStatistics statistics;
    private final PathFormulaManager pfmgr;
    private final TemplatePrecision precision;
    private final Configuration configuration;
    private final CFA cfa;
    private final LogManager logManager;
    private final ShutdownNotifier shutdownNotifier;

    public CongruenceManager(Configuration config, Solver pSolver, TemplateToFormulaConversionManager pTemplateToFormulaConversionManager, FormulaManagerView pFormulaManager, CongruenceStatistics pStatistics, PathFormulaManager pPathFormulaManager, LogManager logger, CFA pCFA, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.templateToFormulaConversionManager = pTemplateToFormulaConversionManager;
        this.cfa = pCFA;
        this.logManager = logger;
        this.configuration = config;
        this.solver = pSolver;
        this.fmgr = pFormulaManager;
        this.statistics = pStatistics;
        this.bvfmgr = this.fmgr.getBitvectorFormulaManager();
        this.pfmgr = pPathFormulaManager;
        this.precision = new TemplatePrecision(logger, config, this.cfa, pTemplateToFormulaConversionManager);
        this.shutdownNotifier = pShutdownNotifier;
    }

    public CongruenceState join(CongruenceState a, CongruenceState b) {
        Map abstraction = Maps.difference(a.getAbstraction(), b.getAbstraction()).entriesInCommon();
        return new CongruenceState(abstraction, this, a.getPointerTargetSet(), a.getSSAMap(), b.getGeneratingState(), a.getNode());
    }

    @Override
    public PrecisionAdjustmentResult performAbstraction(ABEIntermediateState<CongruenceState> pIntermediateState, TemplatePrecision pPrecision, UnmodifiableReachedSet states, AbstractState fullState) throws CPATransferException, InterruptedException {
        return PrecisionAdjustmentResult.create(this.performAbstraction(pIntermediateState.getNode(), pIntermediateState.getPathFormula(), pIntermediateState.getBackpointerState().instantiate(), pPrecision, pIntermediateState.getPathFormula().getPointerTargetSet(), pIntermediateState.getPathFormula().getSsa(), pIntermediateState, states, fullState), pPrecision, PrecisionAdjustmentResult.Action.CONTINUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CongruenceState performAbstraction(CFANode node, PathFormula p, BooleanFormula startConstraints, TemplatePrecision pPrecision, PointerTargetSet pPointerTargetSet, SSAMap pSsaMap, ABEIntermediateState<CongruenceState> generatingState, UnmodifiableReachedSet states, AbstractState fullState) throws CPATransferException, InterruptedException {
        HashMap<Template, Congruence> abstraction = new HashMap<Template, Congruence>();
        this.statistics.congruenceTimer.start();
        try (ProverEnvironment env = this.solver.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            env.push(p.getFormula());
            env.push(startConstraints);
            for (Template template : pPrecision.getTemplatesForNode(node)) {
                if (!this.shouldUseTemplate(template)) continue;
                Formula formula = this.templateToFormulaConversionManager.toFormula(this.pfmgr, this.fmgr, template, p);
                try {
                    env.push(this.fmgr.makeModularCongruence(formula, this.makeBv(this.bvfmgr, formula, 0), 2L, !template.isUnsigned()));
                    if (env.isUnsat()) {
                        abstraction.put(template, Congruence.ODD);
                        continue;
                    }
                }
                finally {
                    env.pop();
                    continue;
                }
                try {
                    env.push(this.fmgr.makeModularCongruence(formula, this.makeBv(this.bvfmgr, formula, 1), 2L, !template.isUnsigned()));
                    if (!env.isUnsat()) continue;
                    abstraction.put(template, Congruence.EVEN);
                }
                finally {
                    env.pop();
                }
            }
        }
        catch (SolverException ex) {
            throw new CPATransferException("Solver exception: ", ex);
        }
        finally {
            this.statistics.congruenceTimer.stop();
        }
        CongruenceState out = new CongruenceState(abstraction, this, pPointerTargetSet, pSsaMap, Optional.of(generatingState), node);
        Optional<ABEAbstractedState<CongruenceState>> sibling = this.findSibling(states, fullState, out);
        if (sibling.isPresent()) {
            out = this.join(sibling.orElseThrow().cast(), out);
        }
        return out;
    }

    public BooleanFormula toFormula(CongruenceState state) {
        return this.toFormula(this.pfmgr, this.fmgr, state, this.pfmgr.makeEmptyPathFormulaWithContext(state.getSSAMap(), state.getPointerTargetSet()));
    }

    public BooleanFormula toFormulaUninstantiated(CongruenceState state, FormulaManagerView pFormulaManager) {
        PathFormulaManagerImpl pfmgrv;
        try {
            pfmgrv = new PathFormulaManagerImpl(pFormulaManager, this.configuration, this.logManager, this.shutdownNotifier, this.cfa, AnalysisDirection.FORWARD);
        }
        catch (InvalidConfigurationException pE) {
            throw new UnsupportedOperationException("Could not construct path formula manager", pE);
        }
        return pFormulaManager.uninstantiate(this.toFormula(pfmgrv, pFormulaManager, state, pfmgrv.makeEmptyPathFormulaWithContext(state.getSSAMap(), state.getPointerTargetSet())));
    }

    public BooleanFormula toFormula(PathFormulaManager pPathFormulaManager, FormulaManagerView pFormulaManager, CongruenceState state, PathFormula ref) {
        Map<Template, Congruence> abstraction = state.getAbstraction();
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>(abstraction.size());
        for (Map.Entry<Template, Congruence> entry : abstraction.entrySet()) {
            Formula remainder;
            Template template = entry.getKey();
            Congruence congruence = entry.getValue();
            Formula formula = this.templateToFormulaConversionManager.toFormula(pPathFormulaManager, pFormulaManager, template, ref);
            switch (congruence) {
                case ODD: {
                    remainder = this.makeBv(pFormulaManager.getBitvectorFormulaManager(), formula, 1);
                    break;
                }
                case EVEN: {
                    remainder = this.makeBv(pFormulaManager.getBitvectorFormulaManager(), formula, 0);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected case");
                }
            }
            constraints.add(pFormulaManager.makeModularCongruence(formula, remainder, 2L, !template.isUnsigned()));
        }
        return pFormulaManager.getBooleanFormulaManager().and(constraints);
    }

    private boolean shouldUseTemplate(Template template) {
        return template.isIntegral() && (template.getKind() == Template.Kind.UPPER_BOUND || this.trackCongruenceSum && template.getKind() == Template.Kind.SUM);
    }

    private Formula makeBv(BitvectorFormulaManager pBvfmgr, Formula other, int value) {
        return pBvfmgr.makeBitvector(pBvfmgr.getLength((BitvectorFormula)other), (long)value);
    }

    @Override
    public CongruenceState getInitialState(CFANode node, StateSpacePartition pPartition) {
        return CongruenceState.empty(this, node);
    }

    @Override
    public TemplatePrecision getInitialPrecision(CFANode node, StateSpacePartition pPartition) {
        return this.precision;
    }

    @Override
    public Optional<ABEAbstractedState<CongruenceState>> strengthen(ABEAbstractedState<CongruenceState> pState, TemplatePrecision pPrecision, Iterable<AbstractState> pOtherStates) {
        return Optional.of(pState);
    }

    @Override
    public boolean isLessOrEqual(ABEAbstractedState<CongruenceState> pState1, ABEAbstractedState<CongruenceState> pState2) {
        return this.isLessOrEqual(pState1.cast(), pState2.cast());
    }

    public boolean isLessOrEqual(CongruenceState a, CongruenceState b) {
        for (Map.Entry<Template, Congruence> e : b) {
            Template template = e.getKey();
            Congruence congruence = e.getValue();
            Optional<Congruence> smallerCongruence = a.get(template);
            if (smallerCongruence.isPresent() && smallerCongruence.orElseThrow() == congruence) continue;
            return false;
        }
        return true;
    }

    private Optional<ABEAbstractedState<CongruenceState>> findSibling(UnmodifiableReachedSet states, AbstractState pArgState, ABEAbstractedState<CongruenceState> state) {
        ImmutableSet filteredSiblings = ImmutableSet.copyOf(AbstractStates.projectToType(states.getReached(pArgState), CongruenceState.class));
        if (filteredSiblings.isEmpty()) {
            return Optional.empty();
        }
        ABEAbstractedState<CongruenceState> a = state;
        while (true) {
            if (a.isAbstract()) {
                ABEAbstractedState aState = a.asAbstracted();
                if (filteredSiblings.contains(aState)) {
                    return Optional.of(aState);
                }
                if (!aState.getGeneratingState().isPresent()) {
                    return Optional.empty();
                }
                a = aState.getGeneratingState().orElseThrow().getBackpointerState();
                continue;
            }
            ABEIntermediateState iState = a.asIntermediate();
            a = iState.getBackpointerState();
        }
    }
}

