/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.congruence;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.cpa.abe.ABEAbstractedState;
import org.sosy_lab.cpachecker.cpa.abe.ABEIntermediateState;
import org.sosy_lab.cpachecker.cpa.congruence.Congruence;
import org.sosy_lab.cpachecker.cpa.congruence.CongruenceManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.templates.Template;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class CongruenceState
implements Iterable<Map.Entry<Template, Congruence>>,
ABEAbstractedState<CongruenceState>,
Graphable {
    private final ImmutableMap<Template, Congruence> data;
    private final CongruenceManager congruenceManager;
    private final PointerTargetSet pointerTargetSet;
    private final SSAMap ssaMap;
    private final Optional<ABEIntermediateState<CongruenceState>> generatingState;
    private final CFANode node;

    public CongruenceState(Map<Template, Congruence> pData, CongruenceManager pCongruenceManager, PointerTargetSet pPointerTargetSet, SSAMap pSsaMap, Optional<ABEIntermediateState<CongruenceState>> pGeneratingState, CFANode pNode) {
        this.data = ImmutableMap.copyOf(pData);
        this.congruenceManager = pCongruenceManager;
        this.pointerTargetSet = pPointerTargetSet;
        this.ssaMap = pSsaMap;
        this.generatingState = pGeneratingState;
        this.node = pNode;
    }

    public Map<Template, Congruence> getAbstraction() {
        return this.data;
    }

    public static CongruenceState empty(CongruenceManager pCongruenceManager, CFANode pNode) {
        return new CongruenceState((Map<Template, Congruence>)ImmutableMap.of(), pCongruenceManager, PointerTargetSet.emptyPointerTargetSet(), SSAMap.emptySSAMap(), Optional.empty(), pNode);
    }

    public Optional<Congruence> get(Template template) {
        return Optional.ofNullable((Congruence)((Object)this.data.get((Object)template)));
    }

    @Override
    public Iterator<Map.Entry<Template, Congruence>> iterator() {
        return this.data.entrySet().iterator();
    }

    @Override
    public String toDOTLabel() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry e : this.data.entrySet()) {
            if (e.getValue() == Congruence.EVEN) {
                b.append(((Template)e.getKey()).toString()).append(" is even\n");
                continue;
            }
            if (e.getValue() != Congruence.ODD) continue;
            b.append(((Template)e.getKey()).toString()).append(" is odd\n");
        }
        return b.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    @Override
    public SSAMap getSSAMap() {
        return this.ssaMap;
    }

    @Override
    public PointerTargetSet getPointerTargetSet() {
        return this.pointerTargetSet;
    }

    @Override
    public Optional<ABEIntermediateState<CongruenceState>> getGeneratingState() {
        return this.generatingState;
    }

    @Override
    public CongruenceState cast() {
        return this;
    }

    @Override
    public BooleanFormula instantiate() {
        return this.congruenceManager.toFormula(this);
    }

    @Override
    public BooleanFormula getFormulaApproximation(FormulaManagerView manager) {
        return this.congruenceManager.toFormulaUninstantiated(this, manager);
    }

    @Override
    public CFANode getNode() {
        return this.node;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.data);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CongruenceState)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        CongruenceState other = (CongruenceState)o;
        return other.data.equals(this.data);
    }
}

