/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints;

import java.util.Collection;
import java.util.Optional;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.constraints.ConstraintsStatistics;
import org.sosy_lab.cpachecker.cpa.constraints.ConstraintsTransferRelation;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsMergeOperator;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsSolver;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.constraints.domain.SubsetLessOrEqualOperator;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.ConstraintsPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.ConstraintsPrecision;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.FullConstraintsPrecision;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;

@Options(prefix="cpa.constraints")
public class ConstraintsCPA
implements ConfigurableProgramAnalysis,
StatisticsProvider,
AutoCloseable {
    @Option(description="Type of less-or-equal operator to use", toUppercase=true)
    private ComparisonType lessOrEqualType = ComparisonType.SUBSET;
    @Option(description="Type of merge operator to use", toUppercase=true)
    private MergeType mergeType = MergeType.SEP;
    private final LogManager logger;
    private AbstractDomain abstractDomain;
    private MergeOperator mergeOperator;
    private StopOperator stopOperator;
    private ConstraintsTransferRelation transferRelation;
    private ConstraintsPrecisionAdjustment precisionAdjustment;
    private ConstraintsPrecision precision;
    private final ConstraintsSolver constraintsSolver;
    private final Solver solver;
    private final ConstraintsStatistics stats = new ConstraintsStatistics();

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ConstraintsCPA.class);
    }

    private ConstraintsCPA(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.solver = Solver.create(pConfig, pLogger, pShutdownNotifier);
        FormulaManagerView formulaManager = this.solver.getFormulaManager();
        CtoFormulaConverter converter = this.initializeCToFormulaConverter(formulaManager, pLogger, pConfig, pShutdownNotifier, pCfa.getMachineModel());
        this.constraintsSolver = new ConstraintsSolver(pConfig, this.solver, formulaManager, converter, this.stats);
        this.abstractDomain = this.initializeAbstractDomain();
        this.mergeOperator = this.initializeMergeOperator();
        this.stopOperator = this.initializeStopOperator();
        this.transferRelation = new ConstraintsTransferRelation(this.constraintsSolver, this.stats, pCfa.getMachineModel(), this.logger, pConfig);
        this.precisionAdjustment = new ConstraintsPrecisionAdjustment(this.stats);
        this.precision = FullConstraintsPrecision.getInstance();
    }

    private CtoFormulaConverter initializeCToFormulaConverter(FormulaManagerView pFormulaManager, LogManager pLogger, Configuration pConfig, ShutdownNotifier pShutdownNotifier, MachineModel pMachineModel) throws InvalidConfigurationException {
        FormulaEncodingWithPointerAliasingOptions options = new FormulaEncodingWithPointerAliasingOptions(pConfig);
        TypeHandlerWithPointerAliasing typeHandler = new TypeHandlerWithPointerAliasing(this.logger, pMachineModel, options);
        return new CToFormulaConverterWithPointerAliasing(options, pFormulaManager, pMachineModel, Optional.empty(), pLogger, pShutdownNotifier, typeHandler, AnalysisDirection.FORWARD);
    }

    private MergeOperator initializeMergeOperator() {
        switch (this.mergeType) {
            case SEP: {
                return MergeSepOperator.getInstance();
            }
            case JOIN_FITTING_CONSTRAINT: {
                return new ConstraintsMergeOperator(this.stats);
            }
        }
        throw new AssertionError((Object)("Unhandled merge type " + this.mergeType));
    }

    private StopOperator initializeStopOperator() {
        return new StopSepOperator(this.abstractDomain);
    }

    private AbstractDomain initializeAbstractDomain() {
        switch (this.lessOrEqualType) {
            case SUBSET: {
                this.abstractDomain = SubsetLessOrEqualOperator.getInstance();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled type for less-or-equal operator: " + this.lessOrEqualType));
            }
        }
        return this.abstractDomain;
    }

    public ConstraintsSolver getSolver() {
        return this.constraintsSolver;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition partition) {
        return new ConstraintsState();
    }

    @Override
    public Precision getInitialPrecision(CFANode node, StateSpacePartition partition) {
        return this.precision;
    }

    public void injectRefinablePrecision(ConstraintsPrecision pNewPrecision) {
        this.precision = pNewPrecision;
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this.stats);
    }

    @Override
    public void close() {
        this.solver.close();
    }

    public static enum MergeType {
        SEP,
        JOIN_FITTING_CONSTRAINT;

    }

    public static enum ComparisonType {
        SUBSET;

    }
}

