/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints;

import java.io.PrintStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.constraints.ConstraintsCPA;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public class ConstraintsStatistics
implements Statistics {
    public final StatTimer trivialRemovalTime = new StatTimer("Time for trivial constraint removal");
    public final StatTimer outdatedRemovalTime = new StatTimer("Time for outdated constraint removal");
    public final StatInt removedTrivial = new StatInt(StatKind.SUM, "Number of removed trivial constraints");
    public final StatInt removedOutdated = new StatInt(StatKind.SUM, "Number of removed outdated constraints");
    public final StatTimer timeForSolving = new StatTimer(StatKind.SUM, "Time for solving constraints");
    public final StatTimer timeForIndependentComputation = new StatTimer(StatKind.SUM, "Time for independent computation");
    public final StatTimer timeForDefinitesComputation = new StatTimer(StatKind.SUM, "Time for resolving definites");
    public final StatTimer timeForModelReuse = new StatTimer(StatKind.SUM, "Time for model re-use attempts");
    public final StatTimer timeForSatCheck = new StatTimer(StatKind.SUM, "Time for SMT check");
    public final StatCounter modelReuseSuccesses = new StatCounter("Successful model re-uses");
    public StatCounter cacheLookups = new StatCounter("Cache lookups");
    public StatTimer directCacheLookupTime = new StatTimer(StatKind.SUM, "Direct cache lookup time");
    public StatCounter directCacheHits = new StatCounter("Direct cache hits");
    public StatTimer subsetLookupTime = new StatTimer(StatKind.SUM, "Subset cache lookup time");
    public StatCounter subsetCacheHits = new StatCounter("Subset cache hits");
    public StatTimer supersetLookupTime = new StatTimer(StatKind.SUM, "Superset cache lookup time");
    public StatCounter supersetCacheHits = new StatCounter("Superset cache hits");
    public StatInt constraintNumberBeforeAdj = new StatInt(StatKind.SUM, "Constraints before refinement in state");
    public StatInt constraintNumberAfterAdj = new StatInt(StatKind.SUM, "Constraints after refinement in state");
    public final StatTimer adjustmentTime = new StatTimer(StatKind.SUM, "Time for constraints adjustment");
    public StatCounter constraintsRemovedInMerge = new StatCounter("Number of constraints removed in merge");
    private String name;

    public ConstraintsStatistics() {
        this.name = ConstraintsCPA.class.getSimpleName();
    }

    public ConstraintsStatistics(String pName) {
        this.name = pName;
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        StatisticsWriter.writingStatisticsTo(out).spacer().putIfUpdatedAtLeastOnce(this.timeForSolving).beginLevel().putIfUpdatedAtLeastOnce(this.timeForIndependentComputation).putIfUpdatedAtLeastOnce(this.timeForModelReuse).putIfUpdatedAtLeastOnce(this.timeForSatCheck).putIfUpdatedAtLeastOnce(this.timeForDefinitesComputation).endLevel().putIfUpdatedAtLeastOnce(this.modelReuseSuccesses).spacer().putIf(this.cacheLookups.getUpdateCount() > 0, this.cacheLookups).putIf(this.cacheLookups.getUpdateCount() > 0, this.directCacheHits).putIfUpdatedAtLeastOnce(this.directCacheLookupTime).putIf(this.subsetLookupTime.getUpdateCount() > 0, this.subsetCacheHits).putIf(this.subsetLookupTime.getUpdateCount() > 0, this.subsetLookupTime).putIf(this.supersetLookupTime.getUpdateCount() > 0, this.supersetCacheHits).putIf(this.supersetLookupTime.getUpdateCount() > 0, this.supersetLookupTime).spacer().putIf(this.trivialRemovalTime.getUpdateCount() > 0, this.removedTrivial).putIf(this.trivialRemovalTime.getUpdateCount() > 0, this.trivialRemovalTime).putIf(this.outdatedRemovalTime.getUpdateCount() > 0, this.removedOutdated).putIf(this.outdatedRemovalTime.getUpdateCount() > 0, this.outdatedRemovalTime).spacer().putIfUpdatedAtLeastOnce(this.constraintNumberAfterAdj).putIfUpdatedAtLeastOnce(this.constraintNumberBeforeAdj).putIfUpdatedAtLeastOnce(this.adjustmentTime);
    }

    @Override
    public @Nullable String getName() {
        return this.name;
    }
}

