/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.constraints.ConstraintsStatistics;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.ConstraintFactory;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsSolver;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.constraints.util.StateSimplifier;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.constraints")
public class ConstraintsTransferRelation
extends ForwardingTransferRelation<ConstraintsState, ConstraintsState, SingletonPrecision> {
    @Option(name="satCheckStrategy", description="When to check the satisfiability of constraints")
    private CheckStrategy checkStrategy = CheckStrategy.AT_ASSUME;
    private final LogManagerWithoutDuplicates logger;
    private MachineModel machineModel;
    private ConstraintsSolver solver;
    private StateSimplifier simplifier;

    public ConstraintsTransferRelation(ConstraintsSolver pSolver, ConstraintsStatistics pStats, MachineModel pMachineModel, LogManager pLogger, Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        this.machineModel = pMachineModel;
        this.simplifier = new StateSimplifier(pConfig, pStats);
        this.solver = pSolver;
    }

    @Override
    protected ConstraintsState handleFunctionCallEdge(FunctionCallEdge pCfaEdge, List<? extends AExpression> pArguments, List<? extends AParameterDeclaration> pParameters, String pCalledFunctionName) {
        return (ConstraintsState)this.state;
    }

    @Override
    protected ConstraintsState handleFunctionReturnEdge(FunctionReturnEdge pCfaEdge, FunctionSummaryEdge pFunctionCallEdge, AFunctionCall pSummaryExpression, String pCallerFunctionName) {
        return (ConstraintsState)this.state;
    }

    @Override
    protected ConstraintsState handleStatementEdge(AStatementEdge pCfaEdge, AStatement pStatement) {
        return (ConstraintsState)this.state;
    }

    @Override
    protected ConstraintsState handleReturnStatementEdge(AReturnStatementEdge pCfaEdge) {
        return (ConstraintsState)this.state;
    }

    @Override
    protected ConstraintsState handleFunctionSummaryEdge(FunctionSummaryEdge pCfaEdge) {
        return (ConstraintsState)this.state;
    }

    @Override
    protected ConstraintsState handleDeclarationEdge(ADeclarationEdge pCfaEdge, ADeclaration pDeclaration) throws CPATransferException {
        return (ConstraintsState)this.state;
    }

    @Override
    protected ConstraintsState handleBlankEdge(BlankEdge cfaEdge) {
        if (cfaEdge.getDescription().equals("INIT GLOBAL VARS")) {
            SymbolicValueFactory.reset();
        }
        return (ConstraintsState)this.state;
    }

    @Override
    protected ConstraintsState handleAssumption(AssumeEdge pCfaEdge, AExpression pExpression, boolean pTruthAssumption) {
        return (ConstraintsState)this.state;
    }

    private ConstraintsState getNewState(ConstraintsState pOldState, AExpression pExpression, ConstraintFactory pFactory, boolean pTruthAssumption) throws UnrecognizedCodeException, SolverException, InterruptedException {
        return this.computeNewStateByCreatingConstraint(pOldState, pExpression, pFactory, pTruthAssumption);
    }

    private ConstraintsState computeNewStateByCreatingConstraint(ConstraintsState pOldState, AExpression pExpression, ConstraintFactory pFactory, boolean pTruthAssumption) throws UnrecognizedCodeException, SolverException, InterruptedException {
        Optional<Constraint> oNewConstraint = this.createConstraint(pExpression, pFactory, pTruthAssumption);
        if (oNewConstraint.isPresent()) {
            ConstraintsState newState = pOldState.copyOf();
            Constraint newConstraint = oNewConstraint.orElseThrow();
            if (newConstraint.isTrivial()) {
                if (this.solver.isUnsat(newConstraint, (ImmutableList<Model.ValueAssignment>)ImmutableList.of(), this.functionName)) {
                    return null;
                }
            } else {
                newState.add(newConstraint);
                return newState;
            }
        }
        return pOldState;
    }

    private Optional<Constraint> createConstraint(AExpression pExpression, ConstraintFactory pFactory, boolean pTruthAssumption) throws UnrecognizedCodeException {
        if (pExpression instanceof JBinaryExpression) {
            return this.createConstraint((JBinaryExpression)pExpression, pFactory, pTruthAssumption);
        }
        if (pExpression instanceof JUnaryExpression) {
            return this.createConstraint((JUnaryExpression)pExpression, pFactory, pTruthAssumption);
        }
        if (pExpression instanceof CBinaryExpression) {
            return this.createConstraint((CBinaryExpression)pExpression, pFactory, pTruthAssumption);
        }
        if (pExpression instanceof AIdExpression) {
            return this.createConstraint((AIdExpression)pExpression, pFactory, pTruthAssumption);
        }
        throw new AssertionError((Object)("Unhandled expression type " + pExpression.getClass()));
    }

    private Optional<Constraint> createConstraint(JBinaryExpression pExpression, ConstraintFactory pFactory, boolean pTruthAssumption) throws UnrecognizedCodeException {
        Constraint constraint = pTruthAssumption ? pFactory.createPositiveConstraint(pExpression) : pFactory.createNegativeConstraint(pExpression);
        return Optional.ofNullable(constraint);
    }

    private Optional<Constraint> createConstraint(JUnaryExpression pExpression, ConstraintFactory pFactory, boolean pTruthAssumption) throws UnrecognizedCodeException {
        Constraint constraint = pTruthAssumption ? pFactory.createPositiveConstraint(pExpression) : pFactory.createNegativeConstraint(pExpression);
        return Optional.ofNullable(constraint);
    }

    private Optional<Constraint> createConstraint(CBinaryExpression pExpression, ConstraintFactory pFactory, boolean pTruthAssumption) throws UnrecognizedCodeException {
        Constraint constraint = pTruthAssumption ? pFactory.createPositiveConstraint(pExpression) : pFactory.createNegativeConstraint(pExpression);
        return Optional.ofNullable(constraint);
    }

    private Optional<Constraint> createConstraint(AIdExpression pExpression, ConstraintFactory pFactory, boolean pTruthAssumption) {
        Constraint constraint = pTruthAssumption ? pFactory.createPositiveConstraint(pExpression) : pFactory.createNegativeConstraint(pExpression);
        return Optional.ofNullable(constraint);
    }

    private ConstraintsState simplify(ConstraintsState pState, ValueAnalysisState pValueState) {
        return this.simplifier.simplify(pState, pValueState);
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pStateToStrengthen, Iterable<AbstractState> pStrengtheningStates, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        assert (pStateToStrengthen instanceof ConstraintsState);
        super.setInfo(pStateToStrengthen, pPrecision, pCfaEdge);
        ConstraintsState initialStateToStrengthen = (ConstraintsState)pStateToStrengthen;
        String currentFunctionName = pCfaEdge.getPredecessor().getFunctionName();
        ArrayList<ConstraintsState> newStates = new ArrayList<ConstraintsState>();
        newStates.add(initialStateToStrengthen);
        boolean nothingChanged = true;
        for (AbstractState currStrengtheningState : pStrengtheningStates) {
            Optional<Collection<ConstraintsState>> oNewStrengthenedStates;
            ConstraintsState currStateToStrengthen = (ConstraintsState)newStates.get(0);
            StrengthenOperator strengthenOperator = null;
            if (currStrengtheningState instanceof ValueAnalysisState) {
                strengthenOperator = new ValueAnalysisStrengthenOperator();
            } else if (currStrengtheningState instanceof AutomatonState) {
                strengthenOperator = new AutomatonStrengthenOperator();
            }
            if (strengthenOperator != null && (oNewStrengthenedStates = strengthenOperator.strengthen(currStateToStrengthen, currStrengtheningState, currentFunctionName, pCfaEdge)).isPresent()) {
                newStates.clear();
                nothingChanged = false;
                Collection<ConstraintsState> strengthenedStates = oNewStrengthenedStates.orElseThrow();
                if (!strengthenedStates.isEmpty()) {
                    ConstraintsState newState = (ConstraintsState)Iterables.getOnlyElement(strengthenedStates);
                    newStates.add(newState);
                }
            }
            if (!newStates.isEmpty()) continue;
            return ImmutableList.of();
        }
        if (nothingChanged) {
            return ImmutableList.of((Object)pStateToStrengthen);
        }
        return ImmutableList.copyOf(newStates);
    }

    private static interface StrengthenOperator {
        public Optional<Collection<ConstraintsState>> strengthen(ConstraintsState var1, AbstractState var2, String var3, CFAEdge var4) throws CPATransferException, InterruptedException;
    }

    private class AutomatonStrengthenOperator
    implements StrengthenOperator {
        private AutomatonStrengthenOperator() {
        }

        @Override
        public Optional<Collection<ConstraintsState>> strengthen(ConstraintsState pStateToStrengthen, AbstractState pStrengtheningState, String pFunctionName, CFAEdge pEdge) throws CPATransferException, InterruptedException {
            assert (pStrengtheningState instanceof AutomatonState);
            if (ConstraintsTransferRelation.this.checkStrategy != CheckStrategy.AT_TARGET) {
                return Optional.empty();
            }
            AutomatonState automatonState = (AutomatonState)pStrengtheningState;
            try {
                if (automatonState.isTarget() && ConstraintsTransferRelation.this.solver.isUnsat(pStateToStrengthen, ConstraintsTransferRelation.this.functionName)) {
                    return Optional.of(ImmutableSet.of());
                }
                return Optional.empty();
            }
            catch (SolverException e) {
                throw new CPATransferException("Error while strengthening.", e);
            }
        }
    }

    private class ValueAnalysisStrengthenOperator
    implements StrengthenOperator {
        private ValueAnalysisStrengthenOperator() {
        }

        @Override
        public Optional<Collection<ConstraintsState>> strengthen(ConstraintsState pStateToStrengthen, AbstractState pValueState, String pFunctionName, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
            assert (pValueState instanceof ValueAnalysisState);
            if (!(pCfaEdge instanceof AssumeEdge)) {
                return Optional.empty();
            }
            ValueAnalysisState valueState = (ValueAnalysisState)pValueState;
            AssumeEdge assume = (AssumeEdge)pCfaEdge;
            ArrayList<ConstraintsState> newStates = new ArrayList<ConstraintsState>();
            boolean truthAssumption = assume.getTruthAssumption();
            AExpression edgeExpression = assume.getExpression();
            ConstraintFactory factory = ConstraintFactory.getInstance(pFunctionName, valueState, ConstraintsTransferRelation.this.machineModel, ConstraintsTransferRelation.this.logger);
            try {
                ConstraintsState newState = ConstraintsTransferRelation.this.getNewState(pStateToStrengthen, edgeExpression, factory, truthAssumption);
                if (newState != null) {
                    newState = ConstraintsTransferRelation.this.simplify(newState, valueState);
                    if (ConstraintsTransferRelation.this.checkStrategy != CheckStrategy.AT_ASSUME || !ConstraintsTransferRelation.this.solver.isUnsat(newState, ConstraintsTransferRelation.this.functionName)) {
                        newStates.add(newState);
                    }
                    if (newState.equals(pStateToStrengthen)) {
                        return Optional.empty();
                    }
                }
                return Optional.of(newStates);
            }
            catch (SolverException e) {
                throw new CPATransferException("Error while strengthening ConstraintsState with ValueAnalysisState", e);
            }
        }
    }

    private static enum CheckStrategy {
        AT_ASSUME,
        AT_TARGET;

    }
}

