/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.constraints.FormulaCreator;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.SymbolicExpressionToCExpressionTransformer;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class FormulaCreatorUsingCConverter
implements FormulaCreator {
    private final CtoFormulaConverter toFormulaTransformer;
    private final String functionName;

    public FormulaCreatorUsingCConverter(CtoFormulaConverter pConverter, String pFunctionName) {
        this.toFormulaTransformer = pConverter;
        this.functionName = pFunctionName;
    }

    @Override
    public BooleanFormula createFormula(Constraint pConstraint) throws UnrecognizedCodeException, InterruptedException {
        SymbolicExpressionToCExpressionTransformer toExpressionTransformer = new SymbolicExpressionToCExpressionTransformer();
        CExpression constraintExpression = pConstraint.accept(toExpressionTransformer);
        return this.toFormulaTransformer.makePredicate(constraintExpression, this.getDummyEdge(), this.functionName, this.getSsaMapBuilder());
    }

    private CFAEdge getDummyEdge() {
        return DummyEdge.getInstance(this.functionName);
    }

    private SSAMap.SSAMapBuilder getSsaMapBuilder() {
        return SSAMap.emptySSAMap().builder();
    }

    private static class DummyEdge
    implements CFAEdge {
        private static final long serialVersionUID = -8457186174249491758L;
        private static final String UNKNOWN = "unknown";
        private static Map<String, DummyEdge> existingEdges = new HashMap<String, DummyEdge>();
        private final CFANode dummyNode;

        private DummyEdge(String pFunctionName) {
            this.dummyNode = CFANode.newDummyCFANode(pFunctionName);
        }

        public static DummyEdge getInstance(String pFunctionName) {
            DummyEdge edge = existingEdges.get(pFunctionName);
            if (edge == null) {
                edge = new DummyEdge(pFunctionName);
                existingEdges.put(pFunctionName, edge);
            }
            return edge;
        }

        @Override
        public CFAEdgeType getEdgeType() {
            return CFAEdgeType.BlankEdge;
        }

        @Override
        public CFANode getPredecessor() {
            return this.dummyNode;
        }

        @Override
        public CFANode getSuccessor() {
            return this.dummyNode;
        }

        @Override
        public Optional<AAstNode> getRawAST() {
            return Optional.empty();
        }

        @Override
        public int getLineNumber() {
            return 0;
        }

        @Override
        public FileLocation getFileLocation() {
            return FileLocation.DUMMY;
        }

        @Override
        public String getRawStatement() {
            return UNKNOWN;
        }

        @Override
        public String getCode() {
            return UNKNOWN;
        }

        @Override
        public String getDescription() {
            return UNKNOWN;
        }
    }
}

