/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints.constraint;

import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JUnaryExpression;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.CExpressionTransformer;
import org.sosy_lab.cpachecker.cpa.value.symbolic.ExpressionTransformer;
import org.sosy_lab.cpachecker.cpa.value.symbolic.JExpressionTransformer;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.type.BooleanValue;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public class ConstraintFactory {
    private final MachineModel machineModel;
    private final LogManagerWithoutDuplicates logger;
    private final String functionName;
    private final ValueAnalysisState valueState;
    private SymbolicValueFactory expressionFactory;

    private ConstraintFactory(String pFunctionName, ValueAnalysisState pValueState, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger) {
        this.machineModel = pMachineModel;
        this.logger = pLogger;
        this.functionName = pFunctionName;
        this.valueState = pValueState;
        this.expressionFactory = SymbolicValueFactory.getInstance();
    }

    public static ConstraintFactory getInstance(String pFunctionName, ValueAnalysisState pValueState, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger) {
        return new ConstraintFactory(pFunctionName, pValueState, pMachineModel, pLogger);
    }

    public Constraint createNegativeConstraint(CBinaryExpression pExpression) throws UnrecognizedCodeException {
        Constraint positiveConstraint = this.createPositiveConstraint(pExpression);
        if (positiveConstraint == null) {
            return null;
        }
        return this.createNot(positiveConstraint);
    }

    public Constraint createNegativeConstraint(JUnaryExpression pExpression) throws UnrecognizedCodeException {
        Constraint positiveConstraint = this.createPositiveConstraint(pExpression);
        if (positiveConstraint == null) {
            return null;
        }
        return this.createNot(positiveConstraint);
    }

    public Constraint createNegativeConstraint(JBinaryExpression pExpression) throws UnrecognizedCodeException {
        Constraint positiveConstraint = this.createPositiveConstraint(pExpression);
        if (positiveConstraint == null) {
            return null;
        }
        return this.createNot(positiveConstraint);
    }

    public Constraint createNegativeConstraint(AIdExpression pExpression) {
        Constraint positiveConstraint = this.createPositiveConstraint(pExpression);
        if (positiveConstraint == null) {
            return null;
        }
        return this.createNot(positiveConstraint);
    }

    public Constraint createPositiveConstraint(CBinaryExpression pExpression) throws UnrecognizedCodeException {
        CExpressionTransformer transformer = this.getCTransformer();
        assert (this.isConstraint(pExpression));
        return (Constraint)((Object)transformer.transform(pExpression));
    }

    private boolean isConstraint(CBinaryExpression pExpression) {
        switch (pExpression.getOperator()) {
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_EQUAL: 
            case GREATER_THAN: 
            case LESS_EQUAL: 
            case LESS_THAN: {
                return true;
            }
        }
        return false;
    }

    public Constraint createPositiveConstraint(JUnaryExpression pExpression) throws UnrecognizedCodeException {
        assert (pExpression.getOperator() == JUnaryExpression.UnaryOperator.NOT);
        return (Constraint)((Object)this.getJavaTransformer().transform(pExpression));
    }

    public Constraint createPositiveConstraint(JBinaryExpression pExpression) throws UnrecognizedCodeException {
        JExpressionTransformer transformer = this.getJavaTransformer();
        assert (this.isConstraint(pExpression));
        return (Constraint)((Object)pExpression.accept(transformer));
    }

    private boolean isConstraint(JBinaryExpression pExpression) {
        switch (pExpression.getOperator()) {
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case NOT_EQUALS: 
            case EQUALS: {
                return true;
            }
        }
        return false;
    }

    public Constraint createPositiveConstraint(AIdExpression pExpression) {
        ExpressionTransformer transformer = new ExpressionTransformer(this.functionName, this.valueState);
        SymbolicExpression symbolicExpression = transformer.visit(pExpression);
        if (symbolicExpression == null) {
            return null;
        }
        if (symbolicExpression instanceof Constraint) {
            return (Constraint)((Object)symbolicExpression);
        }
        return this.transformValueToConstraint(symbolicExpression, pExpression.getExpressionType());
    }

    private Constraint transformValueToConstraint(SymbolicExpression pExpression, Type expressionType) {
        if (this.isNumeric(expressionType)) {
            return this.createEqual(this.getOneConstant(expressionType), pExpression, expressionType, pExpression.getType());
        }
        if (this.isBoolean(expressionType)) {
            assert (expressionType instanceof JType) : "Expression is boolean but not a constraint in C!";
            return this.createEqual(pExpression, this.getTrueValueConstant(), expressionType, pExpression.getType());
        }
        throw new AssertionError((Object)("Unexpected type " + expressionType));
    }

    private JExpressionTransformer getJavaTransformer() {
        return new JExpressionTransformer(this.functionName, this.valueState);
    }

    private CExpressionTransformer getCTransformer() {
        return new CExpressionTransformer(this.functionName, this.valueState, this.machineModel, this.logger);
    }

    private boolean isNumeric(Type pType) {
        if (pType instanceof CType) {
            CType canonicalType = ((CType)pType).getCanonicalType();
            if (canonicalType instanceof CSimpleType) {
                switch (((CSimpleType)canonicalType).getType()) {
                    case FLOAT: 
                    case INT: {
                        return true;
                    }
                }
            }
            return false;
        }
        if (pType instanceof JSimpleType) {
            switch (((JSimpleType)pType).getType()) {
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    return true;
                }
            }
            return false;
        }
        throw new AssertionError((Object)("Unexpected type " + pType));
    }

    private boolean isBoolean(Type pType) {
        if (pType instanceof CType) {
            CType canonicalType = ((CType)pType).getCanonicalType();
            return canonicalType instanceof CSimpleType && ((CSimpleType)canonicalType).getType() == CBasicType.BOOL;
        }
        if (pType instanceof JSimpleType) {
            return ((JSimpleType)pType).getType() == JBasicType.BOOLEAN;
        }
        throw new AssertionError((Object)("Unexpected type " + pType));
    }

    private SymbolicExpression getOneConstant(Type pType) {
        return this.expressionFactory.asConstant(new NumericValue(1L), pType);
    }

    private SymbolicExpression getTrueValueConstant() {
        return this.expressionFactory.asConstant(BooleanValue.valueOf(true), JSimpleType.getBoolean());
    }

    private Constraint createNot(Constraint pConstraint) {
        return this.createNot((SymbolicExpression)((Object)pConstraint));
    }

    private Constraint createNot(SymbolicExpression pSymbolicExpression) {
        return (Constraint)((Object)this.expressionFactory.logicalNot(pSymbolicExpression, pSymbolicExpression.getType()));
    }

    private Constraint createEqual(SymbolicExpression pLeftOperand, SymbolicExpression pRightOperand, Type pExpressionType, Type pCalculationType) {
        return this.expressionFactory.equal(pLeftOperand, pRightOperand, pExpressionType, pCalculationType);
    }
}

