/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints.domain;

import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.constraints.ConstraintsStatistics;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.LogicalNotExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;

public class ConstraintsMergeOperator
implements MergeOperator {
    private final ConstraintsStatistics stats;

    public ConstraintsMergeOperator(ConstraintsStatistics pStats) {
        this.stats = pStats;
    }

    @Override
    public AbstractState merge(AbstractState pState1, AbstractState pState2, Precision pPrecision) {
        SymbolicExpression innerExpression;
        assert (pState1 instanceof ConstraintsState && pState2 instanceof ConstraintsState);
        ConstraintsState stateToUseForWeakening = (ConstraintsState)pState1;
        ConstraintsState stateToWeaken = (ConstraintsState)pState2;
        ConstraintsState weakenedState = stateToWeaken.copyOf();
        if (stateToUseForWeakening.isEmpty() || weakenedState.isEmpty()) {
            return pState2;
        }
        Constraint lastConstraintOfState1 = stateToUseForWeakening.getLastAddedConstraint().orElseThrow();
        Constraint lastConstraintOfState2 = weakenedState.getLastAddedConstraint().orElseThrow();
        if (lastConstraintOfState1 instanceof LogicalNotExpression) {
            if ((lastConstraintOfState1 = (Constraint)((Object)((LogicalNotExpression)lastConstraintOfState1).getOperand())).equals(lastConstraintOfState2)) {
                weakenedState.remove(lastConstraintOfState2);
                this.stats.constraintsRemovedInMerge.inc();
            }
        } else if (lastConstraintOfState2 instanceof LogicalNotExpression && lastConstraintOfState1.equals(innerExpression = ((LogicalNotExpression)lastConstraintOfState2).getOperand())) {
            weakenedState.remove(lastConstraintOfState2);
            this.stats.constraintsRemovedInMerge.inc();
        }
        if (weakenedState.equals(pState2)) {
            return pState2;
        }
        return weakenedState;
    }
}

