/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints.domain;

import com.google.common.truth.Truth;
import java.util.HashSet;
import java.util.Set;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.cpa.constraints.ConstraintsStatistics;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsMergeOperator;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ConstraintsMergeOperatorTest {
    private final ConstraintsMergeOperator op = new ConstraintsMergeOperator(new ConstraintsStatistics());
    private final SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
    private final Type defType = CNumericTypes.INT;
    private final MemoryLocation memLoc1 = MemoryLocation.forIdentifier("id1");
    private final SymbolicExpression idExp1 = this.factory.asConstant(this.factory.newIdentifier(this.memLoc1), this.defType);
    private final SymbolicExpression numExp1 = this.factory.asConstant(new NumericValue(1), this.defType);
    private final Constraint posConst = this.factory.equal(this.idExp1, this.numExp1, this.defType, this.defType);
    private final Constraint negConst = (Constraint)((Object)this.factory.notEqual(this.idExp1, this.numExp1, this.defType, this.defType));

    @Test
    public void testMerge_mergePossible() throws Exception {
        Set<Constraint> constraints = this.getConstraints();
        ConstraintsState state1 = new ConstraintsState(constraints);
        state1.add(this.posConst);
        constraints = this.getConstraints();
        ConstraintsState state2 = new ConstraintsState(constraints);
        state2.add(this.negConst);
        ConstraintsState mergeResult = (ConstraintsState)this.op.merge(state1, state2, SingletonPrecision.getInstance());
        Truth.assertThat((Iterable)mergeResult).hasSize(state2.size() - 1);
        Truth.assertThat((Iterable)mergeResult).doesNotContain((Object)this.negConst);
        state2.remove(this.negConst);
        Truth.assertThat((Iterable)mergeResult).isEqualTo((Object)state2);
    }

    private Set<Constraint> getConstraints() {
        HashSet<Constraint> constraints = new HashSet<Constraint>();
        SymbolicExpression idExp2 = this.factory.asConstant(this.factory.newIdentifier(this.memLoc1), this.defType);
        Constraint currConstr = (Constraint)((Object)this.factory.greaterThan(idExp2, this.numExp1, this.defType, this.defType));
        constraints.add(currConstr);
        currConstr = (Constraint)((Object)this.factory.logicalNot(this.factory.lessThanOrEqual(idExp2, this.numExp1, this.defType, this.defType), this.defType));
        constraints.add(currConstr);
        return constraints;
    }
}

