/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cpa.constraints.ConstraintsStatistics;
import org.sosy_lab.cpachecker.cpa.constraints.FormulaCreator;
import org.sosy_lab.cpachecker.cpa.constraints.FormulaCreatorUsingCConverter;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.util.SymbolicIdentifierLocator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.util.SymbolicValues;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.constraints")
public class ConstraintsSolver {
    @Option(secure=true, description="Whether to use subset caching", name="cacheSubsets")
    private boolean cacheSubsets = true;
    @Option(secure=true, description="Whether to use superset caching", name="cacheSupersets")
    private boolean cacheSupersets = true;
    @Option(secure=true, description="Whether to perform SAT checks only for the last added constraint", name="minimalSatCheck")
    private boolean performMinimalSatCheck = true;
    @Option(secure=true, description="Whether to perform caching of constraint satisfiability results", name="cache")
    private boolean doCaching = true;
    @Option(secure=true, description="Resolve definite assignments", name="resolveDefinites")
    private boolean resolveDefinites = true;
    private ConstraintsCache cache;
    private Solver solver;
    private ProverEnvironment prover;
    private FormulaManagerView formulaManager;
    private BooleanFormulaManagerView booleanFormulaManager;
    private CtoFormulaConverter converter;
    private SymbolicIdentifierLocator locator;
    private Map<Constraint, BooleanFormula> constraintFormulas = new HashMap<Constraint, BooleanFormula>();
    private BooleanFormula literalForSingleAssignment;
    private ConstraintsStatistics stats;

    public ConstraintsSolver(Configuration pConfig, Solver pSolver, FormulaManagerView pFormulaManager, CtoFormulaConverter pConverter, ConstraintsStatistics pStats) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.solver = pSolver;
        this.formulaManager = pFormulaManager;
        this.booleanFormulaManager = this.formulaManager.getBooleanFormulaManager();
        this.literalForSingleAssignment = this.booleanFormulaManager.makeVariable("__A");
        this.converter = pConverter;
        this.locator = SymbolicIdentifierLocator.getInstance();
        this.stats = pStats;
        if (this.doCaching) {
            this.cache = new MatchingConstraintsCache();
            if (this.cacheSubsets) {
                this.cache = new SubsetConstraintsCache(this.cache);
            }
            if (this.cacheSupersets) {
                this.cache = new SupersetConstraintsCache(this.cache);
            }
        } else {
            this.cache = new DummyCache();
        }
    }

    public boolean isUnsat(Constraint pConstraint, ImmutableList<Model.ValueAssignment> pAssignment, String pFunctionName) throws UnrecognizedCodeException, InterruptedException, SolverException {
        ConstraintsState s = new ConstraintsState(Collections.singleton(pConstraint));
        s.setDefiniteAssignment((ImmutableCollection<Model.ValueAssignment>)pAssignment);
        return this.isUnsat(s, pFunctionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnsat(ConstraintsState pConstraints, String pFunctionName) throws SolverException, InterruptedException, UnrecognizedCodeException {
        if (pConstraints.isEmpty()) {
            return false;
        }
        try {
            this.stats.timeForSolving.start();
            Boolean unsat = null;
            Set<Constraint> relevantConstraints = this.getRelevantConstraints(pConstraints);
            Collection<BooleanFormula> constraintsAsFormulas = this.getFullFormula(relevantConstraints, pFunctionName);
            CacheResult res = this.cache.getCachedResult(constraintsAsFormulas);
            if (res.isUnsat()) {
                unsat = true;
            } else if (res.isSat()) {
                unsat = false;
                pConstraints.setModel((List<Model.ValueAssignment>)res.getModelAssignment());
            } else {
                this.prover = this.solver.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);
                BooleanFormula definitesAndConstraints = this.combineWithDefinites(constraintsAsFormulas, pConstraints);
                this.prover.push(definitesAndConstraints);
                try {
                    this.stats.timeForSatCheck.start();
                    unsat = this.prover.isUnsat();
                }
                finally {
                    this.stats.timeForSatCheck.stop();
                }
                if (!unsat.booleanValue()) {
                    ImmutableList newModelAsAssignment = this.prover.getModelAssignments();
                    pConstraints.setModel((List<Model.ValueAssignment>)newModelAsAssignment);
                    this.cache.addSat(constraintsAsFormulas, (ImmutableList<Model.ValueAssignment>)newModelAsAssignment);
                    if (this.resolveDefinites) {
                        pConstraints.setDefiniteAssignment(this.resolveDefiniteAssignments(pConstraints, (List<Model.ValueAssignment>)newModelAsAssignment));
                    }
                    assert (pConstraints.getModel().containsAll(pConstraints.getDefiniteAssignment())) : "Model does not imply definites: " + pConstraints.getModel() + " !=> " + pConstraints.getDefiniteAssignment();
                } else {
                    assert (this.prover.isUnsat()) : "Unsat with definite assignment, but not without. Definite assignment: " + pConstraints.getDefiniteAssignment();
                    this.cache.addUnsat(constraintsAsFormulas);
                }
            }
            boolean bl = unsat;
            return bl;
        }
        finally {
            this.closeProver();
            this.stats.timeForSolving.stop();
        }
    }

    private BooleanFormula combineWithDefinites(Collection<BooleanFormula> pConstraintsAsFormulas, ConstraintsState pConstraints) {
        BooleanFormula singleConstraintFormula = this.booleanFormulaManager.and(pConstraintsAsFormulas);
        BooleanFormula definites = this.getDefAssignmentsFormula(pConstraints);
        return this.booleanFormulaManager.and(definites, singleConstraintFormula);
    }

    private BooleanFormula getDefAssignmentsFormula(ConstraintsState pConstraints) {
        return pConstraints.getDefiniteAssignment().stream().map(Model.ValueAssignment::getAssignmentAsFormula).collect(this.booleanFormulaManager.toConjunction());
    }

    private BooleanFormula createLiteralLabel(BooleanFormula pLiteral, BooleanFormula pFormula) {
        return this.booleanFormulaManager.implication(pLiteral, pFormula);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Constraint> getRelevantConstraints(ConstraintsState pConstraints) {
        HashSet<Constraint> relevantConstraints = new HashSet();
        if (this.performMinimalSatCheck && pConstraints.getLastAddedConstraint().isPresent()) {
            try {
                Sets.SetView relevantIdentifiers;
                this.stats.timeForIndependentComputation.start();
                Constraint lastConstraint = pConstraints.getLastAddedConstraint().orElseThrow();
                relevantConstraints.add(lastConstraint);
                HashSet<Constraint> leftOverConstraints = new HashSet<Constraint>(pConstraints);
                Sets.SetView newRelevantIdentifiers = lastConstraint.accept(this.locator);
                do {
                    relevantIdentifiers = newRelevantIdentifiers;
                    Iterator it = leftOverConstraints.iterator();
                    while (it.hasNext()) {
                        Constraint currentC = (Constraint)it.next();
                        Set<SymbolicIdentifier> containedIdentifiers = currentC.accept(this.locator);
                        if (Sets.intersection(containedIdentifiers, relevantIdentifiers).isEmpty()) continue;
                        newRelevantIdentifiers = Sets.union(newRelevantIdentifiers, containedIdentifiers);
                        relevantConstraints.add(currentC);
                        it.remove();
                    }
                } while (!newRelevantIdentifiers.equals(relevantIdentifiers));
            }
            finally {
                this.stats.timeForIndependentComputation.stop();
            }
        } else {
            relevantConstraints = pConstraints;
        }
        return relevantConstraints;
    }

    private void closeProver() {
        if (this.prover != null) {
            this.prover.close();
            this.prover = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmutableCollection<Model.ValueAssignment> resolveDefiniteAssignments(ConstraintsState pConstraints, List<Model.ValueAssignment> pModel) throws InterruptedException, SolverException {
        try {
            this.stats.timeForDefinitesComputation.start();
            ImmutableCollection<Model.ValueAssignment> immutableCollection = this.computeDefiniteAssignment(pConstraints, pModel);
            return immutableCollection;
        }
        finally {
            this.stats.timeForDefinitesComputation.stop();
        }
    }

    private ImmutableCollection<Model.ValueAssignment> computeDefiniteAssignment(ConstraintsState pState, List<Model.ValueAssignment> pModel) throws SolverException, InterruptedException {
        ImmutableCollection<Model.ValueAssignment> existingDefinites = pState.getDefiniteAssignment();
        ImmutableSet.Builder newDefinites = ImmutableSet.builder();
        for (Model.ValueAssignment val : pModel) {
            if (!SymbolicValues.isSymbolicTerm(val.getName()) || !existingDefinites.contains((Object)val) && !this.isOnlySatisfyingAssignment(val)) continue;
            newDefinites.add((Object)val);
        }
        return newDefinites.build();
    }

    private boolean isOnlySatisfyingAssignment(Model.ValueAssignment pTerm) throws SolverException, InterruptedException {
        BooleanFormula prohibitAssignment = this.formulaManager.makeNot(pTerm.getAssignmentAsFormula());
        prohibitAssignment = this.createLiteralLabel(this.literalForSingleAssignment, prohibitAssignment);
        this.prover.push(prohibitAssignment);
        boolean isUnsat = this.prover.isUnsatWithAssumptions(Collections.singleton(this.literalForSingleAssignment));
        this.prover.pop();
        return isUnsat;
    }

    private FormulaCreator getFormulaCreator(String pFunctionName) {
        return new FormulaCreatorUsingCConverter(this.converter, pFunctionName);
    }

    private Collection<BooleanFormula> getFullFormula(Collection<Constraint> pConstraints, String pFunctionName) throws UnrecognizedCodeException, InterruptedException {
        ArrayList<BooleanFormula> formulas = new ArrayList<BooleanFormula>(pConstraints.size());
        for (Constraint c : pConstraints) {
            if (!this.constraintFormulas.containsKey(c)) {
                this.constraintFormulas.put(c, this.createConstraintFormulas(c, pFunctionName));
            }
            formulas.add(this.constraintFormulas.get(c));
        }
        return formulas;
    }

    private BooleanFormula createConstraintFormulas(Constraint pConstraint, String pFunctionName) throws UnrecognizedCodeException, InterruptedException {
        assert (!this.constraintFormulas.containsKey(pConstraint)) : "Trying to add a formula that already exists!";
        return this.getFormulaCreator(pFunctionName).createFormula(pConstraint);
    }

    private static class CacheResult {
        private static final CacheResult UNSAT_SINGLETON = new CacheResult(Result.UNSAT, Optional.empty());
        private static final CacheResult UNKNOWN_SINGLETON = new CacheResult(Result.UNKNOWN, Optional.empty());
        private Result result;
        private Optional<ImmutableList<Model.ValueAssignment>> modelAssignment;

        public static CacheResult getSat(ImmutableList<Model.ValueAssignment> pModelAssignment) {
            return new CacheResult(Result.SAT, Optional.of(pModelAssignment));
        }

        public static CacheResult getUnsat() {
            return UNSAT_SINGLETON;
        }

        public static CacheResult getUnknown() {
            return UNKNOWN_SINGLETON;
        }

        private CacheResult(Result pResult, Optional<ImmutableList<Model.ValueAssignment>> pModelAssignment) {
            this.result = pResult;
            this.modelAssignment = pModelAssignment;
        }

        public boolean isSat() {
            return this.result.equals((Object)Result.SAT);
        }

        public boolean isUnsat() {
            return this.result.equals((Object)Result.UNSAT);
        }

        public ImmutableList<Model.ValueAssignment> getModelAssignment() {
            Preconditions.checkState((boolean)this.modelAssignment.isPresent(), (Object)"No model exists");
            return this.modelAssignment.orElseThrow();
        }

        static enum Result {
            SAT,
            UNSAT,
            UNKNOWN;

        }
    }

    private static class DummyCache
    implements ConstraintsCache {
        private DummyCache() {
        }

        @Override
        public CacheResult getCachedResult(Collection<BooleanFormula> pConstraints) {
            return CacheResult.getUnknown();
        }

        @Override
        public void addSat(Collection<BooleanFormula> pConstraints, ImmutableList<Model.ValueAssignment> pModelAssignment) {
        }

        @Override
        public void addUnsat(Collection<BooleanFormula> pConstraints) {
        }
    }

    private class SubsetConstraintsCache
    implements ConstraintsCache {
        private ConstraintsCache delegate;
        private Multimap<BooleanFormula, Set<BooleanFormula>> constraintContainedIn = HashMultimap.create();

        public SubsetConstraintsCache(ConstraintsCache pDelegate) {
            this.delegate = pDelegate;
        }

        @Override
        public CacheResult getCachedResult(Collection<BooleanFormula> pConstraints) {
            CacheResult res = this.delegate.getCachedResult(pConstraints);
            if (!res.isSat() && !res.isUnsat()) {
                try {
                    ConstraintsSolver.this.stats.subsetLookupTime.start();
                    res = this.getCachedResultOfSubset(pConstraints);
                    if (res.isSat() || res.isUnsat()) {
                        ConstraintsSolver.this.stats.subsetCacheHits.inc();
                    }
                }
                finally {
                    ConstraintsSolver.this.stats.subsetLookupTime.stop();
                }
            }
            return res;
        }

        @Override
        public void addSat(Collection<BooleanFormula> pConstraints, ImmutableList<Model.ValueAssignment> pModelAssignment) {
            this.add(pConstraints);
            this.delegate.addSat(pConstraints, pModelAssignment);
        }

        @Override
        public void addUnsat(Collection<BooleanFormula> pConstraints) {
            this.add(pConstraints);
            this.delegate.addUnsat(pConstraints);
        }

        private void add(Collection<BooleanFormula> pConstraints) {
            for (BooleanFormula c : pConstraints) {
                this.constraintContainedIn.put((Object)c, (Object)ImmutableSet.copyOf(pConstraints));
            }
        }

        CacheResult getCachedResultOfSubset(Collection<BooleanFormula> pConstraints) {
            Preconditions.checkState((!pConstraints.isEmpty() ? 1 : 0) != 0);
            HashSet containAllConstraints = new HashSet();
            for (BooleanFormula c : pConstraints) {
                ImmutableSet containC = ImmutableSet.copyOf((Collection)this.constraintContainedIn.get((Object)c));
                containAllConstraints.addAll(containC);
            }
            int sizeOfQuery = pConstraints.size();
            for (Set col : containAllConstraints) {
                CacheResult cachedResult = this.delegate.getCachedResult(col);
                if (sizeOfQuery < col.size() || !cachedResult.isUnsat()) continue;
                return cachedResult;
            }
            return CacheResult.getUnknown();
        }
    }

    private class SupersetConstraintsCache
    implements ConstraintsCache {
        private ConstraintsCache delegate;
        private Multimap<BooleanFormula, Set<BooleanFormula>> constraintContainedIn = HashMultimap.create();

        public SupersetConstraintsCache(ConstraintsCache pDelegate) {
            this.delegate = pDelegate;
        }

        @Override
        public CacheResult getCachedResult(Collection<BooleanFormula> pConstraints) {
            CacheResult res = this.delegate.getCachedResult(pConstraints);
            if (!res.isSat() && !res.isUnsat()) {
                try {
                    ConstraintsSolver.this.stats.supersetLookupTime.start();
                    res = this.getCachedResultOfSuperset(pConstraints);
                    if (res.isSat() || res.isUnsat()) {
                        ConstraintsSolver.this.stats.supersetCacheHits.inc();
                    }
                }
                finally {
                    ConstraintsSolver.this.stats.supersetLookupTime.stop();
                }
            }
            return res;
        }

        @Override
        public void addSat(Collection<BooleanFormula> pConstraints, ImmutableList<Model.ValueAssignment> pModelAssignment) {
            this.add(pConstraints);
            this.delegate.addSat(pConstraints, pModelAssignment);
        }

        @Override
        public void addUnsat(Collection<BooleanFormula> pConstraints) {
            this.add(pConstraints);
            this.delegate.addUnsat(pConstraints);
        }

        private void add(Collection<BooleanFormula> pConstraints) {
            for (BooleanFormula c : pConstraints) {
                this.constraintContainedIn.put((Object)c, (Object)ImmutableSet.copyOf(pConstraints));
            }
        }

        CacheResult getCachedResultOfSuperset(Collection<BooleanFormula> pConstraints) {
            Preconditions.checkState((!pConstraints.isEmpty() ? 1 : 0) != 0);
            Set containAllConstraints = null;
            for (BooleanFormula c : pConstraints) {
                ImmutableSet containC = ImmutableSet.copyOf((Collection)this.constraintContainedIn.get((Object)c));
                if (!(containAllConstraints = containAllConstraints == null ? containC : Sets.intersection((Set)containAllConstraints, (Set)containC)).isEmpty()) continue;
                return CacheResult.getUnknown();
            }
            Preconditions.checkNotNull(containAllConstraints);
            int sizeOfQuery = pConstraints.size();
            for (Set col : containAllConstraints) {
                CacheResult cachedResult = this.delegate.getCachedResult(col);
                if (sizeOfQuery > col.size() || !cachedResult.isSat()) continue;
                return cachedResult;
            }
            return CacheResult.getUnknown();
        }
    }

    private class MatchingConstraintsCache
    implements ConstraintsCache {
        private Map<Collection<BooleanFormula>, CacheResult> cacheMap = new HashMap<Collection<BooleanFormula>, CacheResult>();

        private MatchingConstraintsCache() {
        }

        @Override
        public CacheResult getCachedResult(Collection<BooleanFormula> pConstraints) {
            ConstraintsSolver.this.stats.cacheLookups.inc();
            ConstraintsSolver.this.stats.directCacheLookupTime.start();
            try {
                if (this.cacheMap.containsKey(pConstraints)) {
                    ConstraintsSolver.this.stats.directCacheHits.inc();
                    CacheResult cacheResult = this.cacheMap.get(pConstraints);
                    return cacheResult;
                }
                CacheResult cacheResult = CacheResult.getUnknown();
                return cacheResult;
            }
            finally {
                ConstraintsSolver.this.stats.directCacheLookupTime.stop();
            }
        }

        @Override
        public void addSat(Collection<BooleanFormula> pConstraints, ImmutableList<Model.ValueAssignment> pModelAssignment) {
            this.add(pConstraints, CacheResult.getSat(pModelAssignment));
        }

        @Override
        public void addUnsat(Collection<BooleanFormula> pConstraints) {
            this.add(pConstraints, CacheResult.getUnsat());
        }

        private void add(Collection<BooleanFormula> pConstraints, CacheResult pResult) {
            this.cacheMap.put(pConstraints, pResult);
        }
    }

    private static interface ConstraintsCache {
        public CacheResult getCachedResult(Collection<BooleanFormula> var1);

        public void addSat(Collection<BooleanFormula> var1, ImmutableList<Model.ValueAssignment> var2);

        public void addUnsat(Collection<BooleanFormula> var1);
    }
}

