/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.java_smt.api.Model;

public final class ConstraintsState
implements AbstractState,
Graphable,
Set<Constraint> {
    private List<Constraint> constraints;
    private Optional<Constraint> lastAddedConstraint = Optional.empty();
    private ImmutableList<Model.ValueAssignment> definiteAssignment;
    private ImmutableList<Model.ValueAssignment> lastModelAsAssignment = ImmutableList.of();

    public ConstraintsState() {
        this((Set<Constraint>)ImmutableSet.of());
    }

    public ConstraintsState(Set<Constraint> pConstraints) {
        this.constraints = new ArrayList<Constraint>(pConstraints);
        this.definiteAssignment = ImmutableList.of();
    }

    ConstraintsState(ConstraintsState pState) {
        this.constraints = new ArrayList<Constraint>(pState.constraints);
        this.lastAddedConstraint = pState.lastAddedConstraint;
        this.definiteAssignment = ImmutableList.copyOf(pState.definiteAssignment);
        this.lastModelAsAssignment = pState.lastModelAsAssignment;
    }

    public ConstraintsState copyOf() {
        return new ConstraintsState(this);
    }

    @Override
    public boolean add(Constraint pConstraint) {
        Preconditions.checkNotNull((Object)pConstraint);
        this.lastAddedConstraint = Optional.of(pConstraint);
        return !this.constraints.contains(pConstraint) && this.constraints.add(pConstraint);
    }

    @Override
    public boolean remove(Object pObject) {
        boolean changed = this.constraints.remove(pObject);
        if (changed) {
            this.definiteAssignment = ImmutableList.of();
        }
        return changed;
    }

    Optional<Constraint> getLastAddedConstraint() {
        return this.lastAddedConstraint;
    }

    @Override
    public boolean containsAll(Collection<?> pCollection) {
        return this.constraints.containsAll(pCollection);
    }

    @Override
    public boolean addAll(Collection<? extends Constraint> pCollection) {
        boolean changed = false;
        for (Constraint constraint : pCollection) {
            changed |= this.add(constraint);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> pCollection) {
        ArrayList<Constraint> constraintsCopy = new ArrayList<Constraint>(this.constraints);
        boolean changed = false;
        for (Constraint c : constraintsCopy) {
            if (pCollection.contains(c)) continue;
            changed |= this.remove(c);
        }
        if (changed) {
            this.definiteAssignment = ImmutableList.of();
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> pCollection) {
        boolean changed = false;
        for (Object o : pCollection) {
            changed |= this.remove(o);
        }
        if (changed) {
            this.definiteAssignment = ImmutableList.of();
        }
        return changed;
    }

    @Override
    public void clear() {
        this.constraints.clear();
        this.definiteAssignment = ImmutableList.of();
    }

    @Override
    public int size() {
        return this.constraints.size();
    }

    @Override
    public boolean isEmpty() {
        return this.constraints.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.constraints.contains(o);
    }

    public ImmutableCollection<Model.ValueAssignment> getDefiniteAssignment() {
        return this.definiteAssignment;
    }

    void setDefiniteAssignment(ImmutableCollection<Model.ValueAssignment> pAssignment) {
        this.definiteAssignment = pAssignment.asList();
    }

    public ImmutableList<Model.ValueAssignment> getModel() {
        return this.lastModelAsAssignment;
    }

    void setModel(List<Model.ValueAssignment> pModel) {
        this.lastModelAsAssignment = ImmutableList.copyOf(pModel);
    }

    @Override
    public Iterator<Constraint> iterator() {
        return new ConstraintIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstraintsState that = (ConstraintsState)o;
        return this.constraints.equals(that.constraints) && this.definiteAssignment.equals(that.definiteAssignment);
    }

    @Override
    public int hashCode() {
        int result = this.constraints.hashCode();
        result = 31 * result + this.definiteAssignment.hashCode();
        return result;
    }

    @Override
    public Object[] toArray() {
        return this.constraints.toArray();
    }

    @Override
    public <T> T[] toArray(T[] pTs) {
        return this.constraints.toArray(pTs);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (Constraint currConstraint : this.constraints) {
            sb.append(" <");
            sb.append(currConstraint);
            sb.append(">\n");
        }
        return sb.append("] size->  ").append(this.constraints.size()).toString();
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Joiner.on((String)", ").appendTo(sb, this.constraints);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    private class ConstraintIterator
    implements Iterator<Constraint> {
        private int index = -1;

        private ConstraintIterator() {
        }

        @Override
        public boolean hasNext() {
            return ConstraintsState.this.constraints.size() - 1 > this.index;
        }

        @Override
        public Constraint next() {
            ++this.index;
            return ConstraintsState.this.constraints.get(this.index);
        }

        @Override
        public void remove() {
            Preconditions.checkState((this.index >= 0 ? 1 : 0) != 0, (Object)"Iterator not at valid location");
            ConstraintsState.this.constraints.remove(this.index);
            --this.index;
        }
    }
}

