/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints.domain;

import com.google.common.truth.Truth;
import java.util.Iterator;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ConstraintsStateTest {
    private final SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
    private final Type defType = CNumericTypes.INT;
    private final MemoryLocation memLoc1 = MemoryLocation.forIdentifier("id1");
    private final SymbolicIdentifier id1 = this.factory.newIdentifier(this.memLoc1);
    private final SymbolicExpression idExp1 = this.factory.asConstant(this.id1, this.defType);
    private final SymbolicExpression numExp = this.factory.asConstant(new NumericValue(5), this.defType);
    private final Constraint constr1 = this.factory.equal(this.idExp1, this.numExp, this.defType, this.defType);
    private final Constraint constr2 = (Constraint)((Object)this.factory.lessThan(this.idExp1, this.numExp, this.defType, this.defType));
    private final Constraint constr3 = (Constraint)((Object)this.factory.lessThanOrEqual(this.idExp1, this.numExp, this.defType, this.defType));
    private ConstraintsState state;

    @Before
    public void setUp() {
        this.state = new ConstraintsState();
        this.state.add(this.constr1);
        this.state.add(this.constr2);
        this.state.add(this.constr3);
    }

    @Test
    public void testIterator() {
        Iterator<Constraint> it = this.state.iterator();
        it.next();
        it.remove();
        Truth.assertThat((Iterable)this.state).hasSize(2);
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        Truth.assertThat((Iterable)this.state).contains((Object)this.constr2);
        Truth.assertThat((Iterable)this.state).contains((Object)this.constr3);
        it.next();
        it.remove();
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        Truth.assertThat((Iterable)this.state).hasSize(1);
        Truth.assertThat((Iterable)this.state).contains((Object)this.constr3);
        it.next();
        it.remove();
        Truth.assertThat((Boolean)it.hasNext()).isFalse();
        Truth.assertThat((Iterable)this.state).isEmpty();
    }
}

