/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints.domain;

import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class SubsetLessOrEqualOperator
implements AbstractDomain {
    private static final SubsetLessOrEqualOperator SINGLETON = new SubsetLessOrEqualOperator();

    private SubsetLessOrEqualOperator() {
    }

    public static SubsetLessOrEqualOperator getInstance() {
        return SINGLETON;
    }

    @Override
    public boolean isLessOrEqual(AbstractState pLesserState, AbstractState pBiggerState) {
        assert (pLesserState instanceof ConstraintsState);
        assert (pBiggerState instanceof ConstraintsState);
        ConstraintsState lesserState = (ConstraintsState)pLesserState;
        ConstraintsState biggerState = (ConstraintsState)pBiggerState;
        if (biggerState.size() > lesserState.size()) {
            return false;
        }
        return lesserState.containsAll(biggerState);
    }

    @Override
    public AbstractState join(AbstractState state1, AbstractState state2) throws CPAException, InterruptedException {
        throw new UnsupportedOperationException("ConstraintsCPA's domain does not support join");
    }
}

