/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints.refiner;

import com.google.common.base.Function;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.constraints.ConstraintsStatistics;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.ConstraintsPrecision;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class ConstraintsPrecisionAdjustment
implements PrecisionAdjustment {
    private ConstraintsStatistics stats;

    public ConstraintsPrecisionAdjustment(ConstraintsStatistics pStats) {
        this.stats = pStats;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pStateToAdjust, Precision pPrecision, UnmodifiableReachedSet pReachedStates, Function<AbstractState, AbstractState> pStateProjection, AbstractState pFullState) {
        return this.prec((ConstraintsState)pStateToAdjust, (ConstraintsPrecision)pPrecision, pFullState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<PrecisionAdjustmentResult> prec(ConstraintsState pStateToAdjust, ConstraintsPrecision pPrecision, AbstractState pFullState) {
        int constraintsBefore = 0;
        int constraintsAfter = 0;
        this.stats.adjustmentTime.start();
        try {
            ConstraintsState result = pStateToAdjust.copyOf();
            for (Constraint c : pStateToAdjust) {
                ++constraintsBefore;
                CFANode currentLocation = AbstractStates.extractLocation(pFullState);
                if (!pPrecision.isTracked(c, currentLocation)) {
                    result.remove(c);
                    continue;
                }
                ++constraintsAfter;
            }
            this.stats.constraintNumberBeforeAdj.setNextValue(constraintsBefore);
            this.stats.constraintNumberAfterAdj.setNextValue(constraintsAfter);
            result = result.equals(pStateToAdjust) ? pStateToAdjust : result;
            Optional<PrecisionAdjustmentResult> optional = Optional.of(PrecisionAdjustmentResult.create(result, pPrecision, PrecisionAdjustmentResult.Action.CONTINUE));
            return optional;
        }
        finally {
            this.stats.adjustmentTime.stop();
        }
    }
}

