/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints.refiner.precision;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.ConstraintsPrecision;
import org.sosy_lab.cpachecker.cpa.value.symbolic.util.SymbolicValues;

final class ConstraintBasedConstraintsPrecision
implements ConstraintsPrecision {
    private static final ConstraintBasedConstraintsPrecision EMPTY = new ConstraintBasedConstraintsPrecision();
    private SetMultimap<CFANode, Constraint> trackedLocally;
    private Multimap<String, Constraint> trackedInFunction;
    private Set<Constraint> trackedGlobally;

    public static ConstraintsPrecision getEmptyPrecision() {
        return EMPTY;
    }

    private ConstraintBasedConstraintsPrecision(ConstraintBasedConstraintsPrecision pPrecision) {
        Preconditions.checkNotNull((Object)pPrecision);
        this.trackedLocally = pPrecision.trackedLocally;
        this.trackedInFunction = pPrecision.trackedInFunction;
        this.trackedGlobally = pPrecision.trackedGlobally;
    }

    private ConstraintBasedConstraintsPrecision(SetMultimap<CFANode, Constraint> pTrackedLocally, Multimap<String, Constraint> pTrackedInFunction, Set<Constraint> pTrackedGlobally) {
        this.trackedLocally = pTrackedLocally;
        this.trackedInFunction = pTrackedInFunction;
        this.trackedGlobally = pTrackedGlobally;
    }

    private ConstraintBasedConstraintsPrecision() {
        this.trackedLocally = HashMultimap.create();
        this.trackedInFunction = HashMultimap.create();
        this.trackedGlobally = new HashSet<Constraint>();
    }

    @Override
    public boolean isTracked(Constraint pConstraint, CFANode pLocation) {
        for (Constraint c : this.trackedLocally.get((Object)pLocation)) {
            if (!SymbolicValues.representSameCCodeExpression(c, pConstraint)) continue;
            return true;
        }
        for (Constraint c : this.trackedInFunction.get((Object)pLocation.getFunctionName())) {
            if (!SymbolicValues.representSameCCodeExpression(c, pConstraint)) continue;
            return true;
        }
        for (Constraint c : this.trackedGlobally) {
            if (!SymbolicValues.representSameCCodeExpression(c, pConstraint)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConstraintBasedConstraintsPrecision join(ConstraintsPrecision pOther) {
        assert (pOther instanceof ConstraintBasedConstraintsPrecision);
        ConstraintBasedConstraintsPrecision other = (ConstraintBasedConstraintsPrecision)pOther;
        HashMultimap joinedLocal = HashMultimap.create(this.trackedLocally);
        HashMultimap joinedFunctionwise = HashMultimap.create(this.trackedInFunction);
        HashSet<Constraint> joinedGlobal = new HashSet<Constraint>(this.trackedGlobally);
        this.addNewLocalConstraints((Multimap<CFANode, Constraint>)joinedLocal, (Multimap<CFANode, Constraint>)other.trackedLocally);
        this.addNewFunctionConstraints((Multimap<String, Constraint>)joinedFunctionwise, other.trackedInFunction);
        this.addNewGlobalConstraints(joinedGlobal, other.trackedGlobally);
        return new ConstraintBasedConstraintsPrecision((SetMultimap<CFANode, Constraint>)joinedLocal, (Multimap<String, Constraint>)joinedFunctionwise, joinedGlobal);
    }

    private void addNewLocalConstraints(Multimap<CFANode, Constraint> pMapToAddTo, Multimap<CFANode, Constraint> pNewConstraints) {
        for (Map.Entry entry : pNewConstraints.entries()) {
            Constraint constraint;
            CFANode loc = (CFANode)entry.getKey();
            if (this.constraintWithSameMeaningExists(loc, constraint = (Constraint)entry.getValue(), pMapToAddTo)) continue;
            pMapToAddTo.put((Object)loc, (Object)constraint);
        }
    }

    private void addNewFunctionConstraints(Multimap<String, Constraint> pMapToAddTo, Multimap<String, Constraint> pNewConstraints) {
        for (Map.Entry entry : pNewConstraints.entries()) {
            Constraint constraint;
            String function = (String)entry.getKey();
            if (this.constraintWithSameMeaningExists(function, constraint = (Constraint)entry.getValue(), pMapToAddTo)) continue;
            pMapToAddTo.put((Object)function, (Object)constraint);
        }
    }

    private void addNewGlobalConstraints(Set<Constraint> pSetToAddTo, Set<Constraint> pNewConstraints) {
        for (Constraint c : pNewConstraints) {
            if (this.constraintWithSameMeaningExists(c, pNewConstraints)) continue;
            pSetToAddTo.add(c);
        }
    }

    private boolean constraintWithSameMeaningExists(CFANode pLoc, Constraint pConstraint, Multimap<CFANode, Constraint> pTrackedConstraints) {
        if (pTrackedConstraints.containsKey((Object)pLoc)) {
            Collection constraintsOnLocation = pTrackedConstraints.get((Object)pLoc);
            for (Constraint c : constraintsOnLocation) {
                if (!SymbolicValues.representSameCCodeExpression(c, pConstraint)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean constraintWithSameMeaningExists(String pFunctionName, Constraint pConstraint, Multimap<String, Constraint> pTrackedConstraints) {
        if (pTrackedConstraints.containsKey((Object)pFunctionName)) {
            Collection constraintsOnLocation = pTrackedConstraints.get((Object)pFunctionName);
            for (Constraint c : constraintsOnLocation) {
                if (!SymbolicValues.representSameCCodeExpression(c, pConstraint)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean constraintWithSameMeaningExists(Constraint pConstraint, Set<Constraint> pTrackedConstraints) {
        for (Constraint c : pTrackedConstraints) {
            if (!SymbolicValues.representSameCCodeExpression(c, pConstraint)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConstraintBasedConstraintsPrecision withIncrement(ConstraintsPrecision.Increment pIncrement) {
        ConstraintBasedConstraintsPrecision newPrecision = new ConstraintBasedConstraintsPrecision(this);
        newPrecision.trackedGlobally.addAll(pIncrement.getTrackedGlobally());
        newPrecision.trackedInFunction.putAll(pIncrement.getTrackedInFunction());
        newPrecision.trackedLocally.putAll(pIncrement.getTrackedLocally());
        return newPrecision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstraintBasedConstraintsPrecision that = (ConstraintBasedConstraintsPrecision)o;
        return Objects.equals(this.trackedLocally, that.trackedLocally);
    }

    public int hashCode() {
        return Objects.hash(this.trackedLocally);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConstraintBasedConstraintsPrecision[");
        sb.append("\nLocally tracked: {");
        if (!this.trackedLocally.keySet().isEmpty()) {
            sb.append("\n");
            for (Object n : ImmutableList.sortedCopyOf((Iterable)this.trackedLocally.keySet())) {
                sb.append("\t").append(n).append(" -> ");
                for (Constraint c : this.trackedLocally.get(n)) {
                    sb.append(c.getRepresentation()).append(", ");
                }
                sb.append("\n");
            }
        }
        sb.append("} -> size: ").append(this.trackedLocally.size());
        sb.append("\nFunctionwise tracked: {");
        if (!this.trackedInFunction.keySet().isEmpty()) {
            ImmutableList functions = ImmutableList.sortedCopyOf((Iterable)this.trackedInFunction.keySet());
            sb.append("\n");
            for (String f : functions) {
                sb.append("\t").append(f).append(" -> ");
                for (Constraint c : this.trackedInFunction.get((Object)f)) {
                    sb.append(c.getRepresentation()).append(", ");
                }
                sb.append("\n");
            }
        }
        sb.append("} -> size: ").append(this.trackedInFunction.size());
        sb.append("\nGlobally tracked: {");
        for (Constraint c : this.trackedGlobally) {
            sb.append(c).append(", ");
        }
        sb.append("} -> size: ").append(this.trackedGlobally.size());
        return sb.toString();
    }
}

